package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.AfiSafiGaugeTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Stat Type = 9: Number of routes in per-AFI/SAFI Adj-RIB-In. The value is 
 * structured as: AFI (2 bytes), SAFI (1 byte), followed by a 64-bit Gauge.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container per-afi-safi-adj-rib-in-tlv {
 *   uses afi-safi-gauge-tlv;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/stat-tlvs/per-afi-safi-adj-rib-in-tlv</i>
 *
 * <p>To create instances of this class use {@link PerAfiSafiAdjRibInTlvBuilder}.
 * @see PerAfiSafiAdjRibInTlvBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PerAfiSafiAdjRibInTlv
    extends
    ChildOf<StatTlvs>,
    Augmentable<PerAfiSafiAdjRibInTlv>,
    AfiSafiGaugeTlv
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("per-afi-safi-adj-rib-in-tlv");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.@NonNull PerAfiSafiAdjRibInTlv obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAfi());
        result = prime * result + Objects.hashCode(obj.getCount());
        result = prime * result + Objects.hashCode(obj.getSafi());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.@NonNull PerAfiSafiAdjRibInTlv thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAfi(), other.getAfi())) {
            return false;
        }
        if (!Objects.equals(thisObj.getCount(), other.getCount())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSafi(), other.getSafi())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.@NonNull PerAfiSafiAdjRibInTlv obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PerAfiSafiAdjRibInTlv");
        CodeHelpers.appendValue(helper, "afi", obj.getAfi());
        CodeHelpers.appendValue(helper, "count", obj.getCount());
        CodeHelpers.appendValue(helper, "safi", obj.getSafi());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }

}

