package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Type = 0: String. The Information field contains a free-form UTF-8 string whose 
 * length is given by the Information Length field. Inclusion of this TLV is 
 * optional. Multiple String TLVs MAY be included in the message.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container string-tlv {
 *   uses tlv;
 *   leaf string-info {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/string-tlv/string-tlv</i>
 *
 * <p>To create instances of this class use {@link StringTlvBuilder}.
 * @see StringTlvBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface StringTlv
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StringTlv>,
    Augmentable<StringTlv>,
    Tlv
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("string-tlv");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlv> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlv.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.@NonNull StringTlv obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getStringInfo());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.@NonNull StringTlv thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlv other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlv.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getStringInfo(), other.getStringInfo())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.@NonNull StringTlv obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("StringTlv");
        CodeHelpers.appendValue(helper, "stringInfo", obj.getStringInfo());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return stringInfo, or {@code null} if it is not present.
     *
     * @return {@code String} stringInfo, or {@code null} if it is not present.
     *
     */
    String getStringInfo();
    
    /**
     * Return stringInfo, guaranteed to be non-null.
     *
     * @return {@code String} stringInfo, guaranteed to be non-null.
     * @throws NoSuchElementException if stringInfo is not present
     *
     */
    default @NonNull String requireStringInfo() {
        return CodeHelpers.require(getStringInfo(), "stringinfo");
    }

}

