package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.BmpMonitorConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.BmpMonitorConfigKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-bmp-monitor-config</b>
 * <pre>
 * container odl-bmp-monitors {
 *   list bmp-monitor-config {
 *     key monitor-id;
 *     leaf monitor-id {
 *       type bmp-monitor:monitor-id;
 *     }
 *     uses server-config;
 *     list monitored-router {
 *       leaf address {
 *         type inet:ip-address-no-zone;
 *       }
 *       key address;
 *       leaf active {
 *         type boolean;
 *       }
 *       leaf port {
 *         when "../active = 'true'";
 *         type inet:port-number;
 *       }
 *       leaf password {
 *         type rfc2385:rfc2385-key;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-bmp-monitor-config/odl-bmp-monitors</i>
 *
 * <p>To create instances of this class use {@link OdlBmpMonitorsBuilder}.
 * @see OdlBmpMonitorsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface OdlBmpMonitors
    extends
    ChildOf<OdlBmpMonitorConfigData>,
    Augmentable<OdlBmpMonitors>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("odl-bmp-monitors");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.OdlBmpMonitors> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.OdlBmpMonitors.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.@NonNull OdlBmpMonitors obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBmpMonitorConfig());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.@NonNull OdlBmpMonitors thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.OdlBmpMonitors other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.OdlBmpMonitors.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getBmpMonitorConfig(), other.getBmpMonitorConfig())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.@NonNull OdlBmpMonitors obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("OdlBmpMonitors");
        CodeHelpers.appendValue(helper, "bmpMonitorConfig", obj.getBmpMonitorConfig());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return bmpMonitorConfig, or {@code null} if it is not present.
     *
     * @return {@code Map<BmpMonitorConfigKey, BmpMonitorConfig>} bmpMonitorConfig, or {@code null} if it is not present.
     *
     */
    @Nullable Map<BmpMonitorConfigKey, BmpMonitorConfig> getBmpMonitorConfig();
    
    /**
     * Return bmpMonitorConfig, or an empty list if it is not present.
     *
     * @return {@code Map<BmpMonitorConfigKey, BmpMonitorConfig>} bmpMonitorConfig, or an empty list if it is not present.
     *
     */
    default @NonNull Map<BmpMonitorConfigKey, BmpMonitorConfig> nonnullBmpMonitorConfig() {
        return CodeHelpers.nonnull(getBmpMonitorConfig());
    }

}

