package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.ServerConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouterKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config.Server;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link BmpMonitorConfigBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BmpMonitorConfigBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new BmpMonitorConfigBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BmpMonitorConfigBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BmpMonitorConfigBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class BmpMonitorConfigBuilder implements Builder<BmpMonitorConfig> {

    private MonitorId _monitorId;
    private Map<MonitoredRouterKey, MonitoredRouter> _monitoredRouter;
    private Server _server;
    private BmpMonitorConfigKey key;


    Map<Class<? extends Augmentation<BmpMonitorConfig>>, Augmentation<BmpMonitorConfig>> augmentation = Collections.emptyMap();

    public BmpMonitorConfigBuilder() {
    }
    
    
    
    public BmpMonitorConfigBuilder(ServerConfig arg) {
        this._server = arg.getServer();
    }
    

    public BmpMonitorConfigBuilder(BmpMonitorConfig base) {
        Map<Class<? extends Augmentation<BmpMonitorConfig>>, Augmentation<BmpMonitorConfig>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._monitorId = base.getMonitorId();
        this._monitoredRouter = base.getMonitoredRouter();
        this._server = base.getServer();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ServerConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServerConfig) {
            this._server = ((ServerConfig)arg).getServer();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ServerConfig]");
    }

    public BmpMonitorConfigKey key() {
        return key;
    }
    
    public MonitorId getMonitorId() {
        return _monitorId;
    }
    
    public Map<MonitoredRouterKey, MonitoredRouter> getMonitoredRouter() {
        return _monitoredRouter;
    }
    
    public Server getServer() {
        return _server;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BmpMonitorConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public BmpMonitorConfigBuilder withKey(final BmpMonitorConfigKey key) {
        this.key = key;
        return this;
    }
    
    public BmpMonitorConfigBuilder setMonitorId(final MonitorId value) {
        this._monitorId = value;
        return this;
    }
    public BmpMonitorConfigBuilder setMonitoredRouter(final Map<MonitoredRouterKey, MonitoredRouter> values) {
        this._monitoredRouter = values;
        return this;
    }
    
    public BmpMonitorConfigBuilder setServer(final Server value) {
        this._server = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public BmpMonitorConfigBuilder addAugmentation(Augmentation<BmpMonitorConfig> augmentation) {
        Class<? extends Augmentation<BmpMonitorConfig>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public BmpMonitorConfigBuilder removeAugmentation(Class<? extends Augmentation<BmpMonitorConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BmpMonitorConfig build() {
        return new BmpMonitorConfigImpl(this);
    }

    private static final class BmpMonitorConfigImpl
        extends AbstractAugmentable<BmpMonitorConfig>
        implements BmpMonitorConfig {
    
        private final MonitorId _monitorId;
        private final Map<MonitoredRouterKey, MonitoredRouter> _monitoredRouter;
        private final Server _server;
        private final BmpMonitorConfigKey key;
    
        BmpMonitorConfigImpl(BmpMonitorConfigBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new BmpMonitorConfigKey(base.getMonitorId());
            }
            this._monitorId = key.getMonitorId();
            this._monitoredRouter = CodeHelpers.emptyToNull(base.getMonitoredRouter());
            this._server = base.getServer();
        }
    
        @Override
        public BmpMonitorConfigKey key() {
            return key;
        }
        
        @Override
        public MonitorId getMonitorId() {
            return _monitorId;
        }
        
        @Override
        public Map<MonitoredRouterKey, MonitoredRouter> getMonitoredRouter() {
            return _monitoredRouter;
        }
        
        @Override
        public Server getServer() {
            return _server;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = BmpMonitorConfig.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return BmpMonitorConfig.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return BmpMonitorConfig.bindingToString(this);
        }
    }
}
