package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.BmpMonitorConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.rfc2385.cfg.rev160324.Rfc2385Key;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-bmp-monitor-config</b>
 * <pre>
 * list monitored-router {
 *   leaf address {
 *     type inet:ip-address-no-zone;
 *   }
 *   key address;
 *   leaf active {
 *     type boolean;
 *   }
 *   leaf port {
 *     when "../active = 'true'";
 *     type inet:port-number;
 *   }
 *   leaf password {
 *     type rfc2385:rfc2385-key;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-bmp-monitor-config/odl-bmp-monitors/bmp-monitor-config/monitored-router</i>
 *
 * <p>To create instances of this class use {@link MonitoredRouterBuilder}.
 * @see MonitoredRouterBuilder
 * @see MonitoredRouterKey
 *
 */
@Generated("mdsal-binding-generator")
public interface MonitoredRouter
    extends
    ChildOf<BmpMonitorConfig>,
    Augmentable<MonitoredRouter>,
    Identifiable<MonitoredRouterKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("monitored-router");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.@NonNull MonitoredRouter obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getActive());
        result = prime * result + Objects.hashCode(obj.getAddress());
        result = prime * result + Objects.hashCode(obj.getPassword());
        result = prime * result + Objects.hashCode(obj.getPort());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.@NonNull MonitoredRouter thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getActive(), other.getActive())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPort(), other.getPort())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPassword(), other.getPassword())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAddress(), other.getAddress())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.@NonNull MonitoredRouter obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("MonitoredRouter");
        CodeHelpers.appendValue(helper, "active", obj.getActive());
        CodeHelpers.appendValue(helper, "address", obj.getAddress());
        CodeHelpers.appendValue(helper, "password", obj.getPassword());
        CodeHelpers.appendValue(helper, "port", obj.getPort());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    @Override
    MonitoredRouterKey key();
    
    /**
     * Return address, or {@code null} if it is not present.
     *
     * @return {@code IpAddressNoZone} address, or {@code null} if it is not present.
     *
     */
    IpAddressNoZone getAddress();
    
    /**
     * Return address, guaranteed to be non-null.
     *
     * @return {@code IpAddressNoZone} address, guaranteed to be non-null.
     * @throws NoSuchElementException if address is not present
     *
     */
    default @NonNull IpAddressNoZone requireAddress() {
        return CodeHelpers.require(getAddress(), "address");
    }
    
    /**
     * Return active, or {@code null} if it is not present.
     *
     * @return {@code Boolean} active, or {@code null} if it is not present.
     *
     */
    Boolean getActive();
    
    /**
     * Return active, guaranteed to be non-null.
     *
     * @return {@code Boolean} active, guaranteed to be non-null.
     * @throws NoSuchElementException if active is not present
     *
     */
    default @NonNull Boolean requireActive() {
        return CodeHelpers.require(getActive(), "active");
    }
    
    /**
     * Return port, or {@code null} if it is not present.
     *
     * @return {@code PortNumber} port, or {@code null} if it is not present.
     *
     */
    PortNumber getPort();
    
    /**
     * Return port, guaranteed to be non-null.
     *
     * @return {@code PortNumber} port, guaranteed to be non-null.
     * @throws NoSuchElementException if port is not present
     *
     */
    default @NonNull PortNumber requirePort() {
        return CodeHelpers.require(getPort(), "port");
    }
    
    /**
     * Return password, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         RFC2385 shared secret
     *     </code>
     * </pre>
     *
     * @return {@code Rfc2385Key} password, or {@code null} if it is not present.
     *
     */
    Rfc2385Key getPassword();
    
    /**
     * Return password, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         RFC2385 shared secret
     *     </code>
     * </pre>
     *
     * @return {@code Rfc2385Key} password, guaranteed to be non-null.
     * @throws NoSuchElementException if password is not present
     *
     */
    default @NonNull Rfc2385Key requirePassword() {
        return CodeHelpers.require(getPassword(), "password");
    }

}

