package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.ServerConfig;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-bmp-monitor-config</b>
 * <pre>
 * container server {
 *   leaf binding-address {
 *     type inet:ip-address-no-zone;
 *     default 0.0.0.0;
 *   }
 *   leaf binding-port {
 *     type inet:port-number;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-bmp-monitor-config/server-config/server</i>
 *
 * <p>To create instances of this class use {@link ServerBuilder}.
 * @see ServerBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Server
    extends
    ChildOf<ServerConfig>,
    Augmentable<Server>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("server");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config.Server> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config.Server.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config.@NonNull Server obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBindingAddress());
        result = prime * result + Objects.hashCode(obj.getBindingPort());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config.@NonNull Server thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config.Server other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config.Server.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getBindingPort(), other.getBindingPort())) {
            return false;
        }
        if (!Objects.equals(thisObj.getBindingAddress(), other.getBindingAddress())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config.@NonNull Server obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Server");
        CodeHelpers.appendValue(helper, "bindingAddress", obj.getBindingAddress());
        CodeHelpers.appendValue(helper, "bindingPort", obj.getBindingPort());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return bindingAddress, or {@code null} if it is not present.
     *
     * @return {@code IpAddressNoZone} bindingAddress, or {@code null} if it is not present.
     *
     */
    IpAddressNoZone getBindingAddress();
    
    /**
     * Return bindingAddress, guaranteed to be non-null.
     *
     * @return {@code IpAddressNoZone} bindingAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if bindingAddress is not present
     *
     */
    default @NonNull IpAddressNoZone requireBindingAddress() {
        return CodeHelpers.require(getBindingAddress(), "bindingaddress");
    }
    
    /**
     * Return bindingPort, or {@code null} if it is not present.
     *
     * @return {@code PortNumber} bindingPort, or {@code null} if it is not present.
     *
     */
    PortNumber getBindingPort();
    
    /**
     * Return bindingPort, guaranteed to be non-null.
     *
     * @return {@code PortNumber} bindingPort, guaranteed to be non-null.
     * @throws NoSuchElementException if bindingPort is not present
     *
     */
    default @NonNull PortNumber requireBindingPort() {
        return CodeHelpers.require(getBindingPort(), "bindingport");
    }

}

