package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.RouterKey;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * grouping routers {
 *   list router {
 *     key router-id;
 *     leaf name {
 *       type string;
 *     }
 *     leaf description {
 *       type string;
 *     }
 *     leaf info {
 *       type string;
 *     }
 *     leaf router-id {
 *       type router-id;
 *     }
 *     leaf status {
 *       type status;
 *     }
 *     uses peers;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/routers</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface Routers
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("routers");

    @Override
    Class<? extends Routers> implementedInterface();
    
    /**
     * Return router, or {@code null} if it is not present.
     *
     * @return {@code Map<RouterKey, Router>} router, or {@code null} if it is not present.
     *
     */
    @Nullable Map<RouterKey, Router> getRouter();
    
    /**
     * Return router, or an empty list if it is not present.
     *
     * @return {@code Map<RouterKey, Router>} router, or an empty list if it is not present.
     *
     */
    default @NonNull Map<RouterKey, Router> nonnullRouter() {
        return CodeHelpers.nonnull(getRouter());
    }

}

