package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.AfiSafiRouteCounter;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * list afi-safi {
 *   uses bgp-mp:bgp-table-type;
 *   key "afi safi";
 *   leaf count {
 *     type yang:gauge64;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/afi-safi-route-counter/afi-safi</i>
 *
 * <p>To create instances of this class use {@link AfiSafiBuilder}.
 * @see AfiSafiBuilder
 * @see AfiSafiKey
 *
 */
@Generated("mdsal-binding-generator")
public interface AfiSafi
    extends
    ChildOf<AfiSafiRouteCounter>,
    Augmentable<AfiSafi>,
    BgpTableType,
    Identifiable<AfiSafiKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("afi-safi");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.AfiSafi> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.AfiSafi.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.@NonNull AfiSafi obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAfi());
        result = prime * result + Objects.hashCode(obj.getCount());
        result = prime * result + Objects.hashCode(obj.getSafi());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.@NonNull AfiSafi thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.AfiSafi other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.AfiSafi.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAfi(), other.getAfi())) {
            return false;
        }
        if (!Objects.equals(thisObj.getCount(), other.getCount())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSafi(), other.getSafi())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.@NonNull AfiSafi obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("AfiSafi");
        CodeHelpers.appendValue(helper, "afi", obj.getAfi());
        CodeHelpers.appendValue(helper, "count", obj.getCount());
        CodeHelpers.appendValue(helper, "safi", obj.getSafi());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    @Override
    AfiSafiKey key();
    
    /**
     * Return count, or {@code null} if it is not present.
     *
     * @return {@code Gauge64} count, or {@code null} if it is not present.
     *
     */
    Gauge64 getCount();
    
    /**
     * Return count, guaranteed to be non-null.
     *
     * @return {@code Gauge64} count, guaranteed to be non-null.
     * @throws NoSuchElementException if count is not present
     *
     */
    default @NonNull Gauge64 requireCount() {
        return CodeHelpers.require(getCount(), "count");
    }

}

