package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link AfiSafiBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AfiSafiBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new AfiSafiBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AfiSafiBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AfiSafiBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class AfiSafiBuilder implements Builder<AfiSafi> {

    private Class<? extends AddressFamily> _afi;
    private Gauge64 _count;
    private Class<? extends SubsequentAddressFamily> _safi;
    private AfiSafiKey key;


    Map<Class<? extends Augmentation<AfiSafi>>, Augmentation<AfiSafi>> augmentation = Collections.emptyMap();

    public AfiSafiBuilder() {
    }
    
    
    
    public AfiSafiBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }
    

    public AfiSafiBuilder(AfiSafi base) {
        Map<Class<? extends Augmentation<AfiSafi>>, Augmentation<AfiSafi>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._afi = base.getAfi();
        this._safi = base.getSafi();
        this._count = base.getCount();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>BgpTableType</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[BgpTableType]");
    }

    public AfiSafiKey key() {
        return key;
    }
    
    public Class<? extends AddressFamily> getAfi() {
        return _afi;
    }
    
    public Gauge64 getCount() {
        return _count;
    }
    
    public Class<? extends SubsequentAddressFamily> getSafi() {
        return _safi;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AfiSafi>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AfiSafiBuilder withKey(final AfiSafiKey key) {
        this.key = key;
        return this;
    }
    
    public AfiSafiBuilder setAfi(final Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }
    
    public AfiSafiBuilder setCount(final Gauge64 value) {
        this._count = value;
        return this;
    }
    
    public AfiSafiBuilder setSafi(final Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AfiSafiBuilder addAugmentation(Augmentation<AfiSafi> augmentation) {
        Class<? extends Augmentation<AfiSafi>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AfiSafiBuilder removeAugmentation(Class<? extends Augmentation<AfiSafi>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public AfiSafi build() {
        return new AfiSafiImpl(this);
    }

    private static final class AfiSafiImpl
        extends AbstractAugmentable<AfiSafi>
        implements AfiSafi {
    
        private final Class<? extends AddressFamily> _afi;
        private final Gauge64 _count;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private final AfiSafiKey key;
    
        AfiSafiImpl(AfiSafiBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new AfiSafiKey(base.getAfi(), base.getSafi());
            }
            this._afi = key.getAfi();
            this._safi = key.getSafi();
            this._count = base.getCount();
        }
    
        @Override
        public AfiSafiKey key() {
            return key;
        }
        
        @Override
        public Class<? extends AddressFamily> getAfi() {
            return _afi;
        }
        
        @Override
        public Gauge64 getCount() {
            return _count;
        }
        
        @Override
        public Class<? extends SubsequentAddressFamily> getSafi() {
            return _safi;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AfiSafi.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AfiSafi.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AfiSafi.bindingToString(this);
        }
    }
}
