package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.BmpMonitor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Routers;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * list monitor {
 *   config false;
 *   key monitor-id;
 *   leaf monitor-id {
 *     type monitor-id;
 *   }
 *   uses routers;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/bmp-monitor/monitor</i>
 *
 * <p>To create instances of this class use {@link MonitorBuilder}.
 * @see MonitorBuilder
 * @see MonitorKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Monitor
    extends
    ChildOf<BmpMonitor>,
    Augmentable<Monitor>,
    Routers,
    Identifiable<MonitorKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("monitor");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.Monitor> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.Monitor.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.@NonNull Monitor obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getMonitorId());
        result = prime * result + Objects.hashCode(obj.getRouter());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.@NonNull Monitor thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.Monitor other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.Monitor.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getMonitorId(), other.getMonitorId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRouter(), other.getRouter())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.@NonNull Monitor obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Monitor");
        CodeHelpers.appendValue(helper, "monitorId", obj.getMonitorId());
        CodeHelpers.appendValue(helper, "router", obj.getRouter());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    @Override
    MonitorKey key();
    
    /**
     * Return monitorId, or {@code null} if it is not present.
     *
     * @return {@code MonitorId} monitorId, or {@code null} if it is not present.
     *
     */
    MonitorId getMonitorId();
    
    /**
     * Return monitorId, guaranteed to be non-null.
     *
     * @return {@code MonitorId} monitorId, guaranteed to be non-null.
     * @throws NoSuchElementException if monitorId is not present
     *
     */
    default @NonNull MonitorId requireMonitorId() {
        return CodeHelpers.require(getMonitorId(), "monitorid");
    }

}

