package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Routers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.RouterKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link MonitorBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     MonitorBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new MonitorBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of MonitorBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see MonitorBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class MonitorBuilder implements Builder<Monitor> {

    private MonitorId _monitorId;
    private Map<RouterKey, Router> _router;
    private MonitorKey key;


    Map<Class<? extends Augmentation<Monitor>>, Augmentation<Monitor>> augmentation = Collections.emptyMap();

    public MonitorBuilder() {
    }
    
    
    
    public MonitorBuilder(Routers arg) {
        this._router = arg.getRouter();
    }
    

    public MonitorBuilder(Monitor base) {
        Map<Class<? extends Augmentation<Monitor>>, Augmentation<Monitor>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._monitorId = base.getMonitorId();
        this._router = base.getRouter();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>Routers</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Routers) {
            this._router = ((Routers)arg).getRouter();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Routers]");
    }

    public MonitorKey key() {
        return key;
    }
    
    public MonitorId getMonitorId() {
        return _monitorId;
    }
    
    public Map<RouterKey, Router> getRouter() {
        return _router;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Monitor>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MonitorBuilder withKey(final MonitorKey key) {
        this.key = key;
        return this;
    }
    
    public MonitorBuilder setMonitorId(final MonitorId value) {
        this._monitorId = value;
        return this;
    }
    public MonitorBuilder setRouter(final Map<RouterKey, Router> values) {
        this._router = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MonitorBuilder addAugmentation(Augmentation<Monitor> augmentation) {
        Class<? extends Augmentation<Monitor>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MonitorBuilder removeAugmentation(Class<? extends Augmentation<Monitor>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Monitor build() {
        return new MonitorImpl(this);
    }

    private static final class MonitorImpl
        extends AbstractAugmentable<Monitor>
        implements Monitor {
    
        private final MonitorId _monitorId;
        private final Map<RouterKey, Router> _router;
        private final MonitorKey key;
    
        MonitorImpl(MonitorBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new MonitorKey(base.getMonitorId());
            }
            this._monitorId = key.getMonitorId();
            this._router = CodeHelpers.emptyToNull(base.getRouter());
        }
    
        @Override
        public MonitorKey key() {
            return key;
        }
        
        @Override
        public MonitorId getMonitorId() {
            return _monitorId;
        }
        
        @Override
        public Map<RouterKey, Router> getRouter() {
            return _router;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Monitor.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Monitor.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Monitor.bindingToString(this);
        }
    }
}
