package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Peers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PeerSession;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PostPolicyRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PrePolicyRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * list peer {
 *   key peer-id;
 *   leaf peer-id {
 *     type rib:peer-id;
 *   }
 *   uses bmp-msg:peer;
 *   leaf router-distinguisher {
 *     type string;
 *   }
 *   container peer-session {
 *     uses bmp-msg:peer-up;
 *     leaf status {
 *       type status;
 *     }
 *     uses bmp-msg:timestamp;
 *   }
 *   container stats {
 *     leaf rejected-prefixes {
 *       type yang:counter32;
 *     }
 *     leaf duplicate-prefix-advertisements {
 *       type yang:counter32;
 *     }
 *     leaf duplicate-withdraws {
 *       type yang:counter32;
 *     }
 *     leaf invalidated-cluster-list-loop {
 *       type yang:counter32;
 *     }
 *     leaf invalidated-as-path-loop {
 *       type yang:counter32;
 *     }
 *     leaf invalidated-originator-id {
 *       type yang:counter32;
 *     }
 *     leaf invalidated-as-confed-loop {
 *       type yang:counter32;
 *     }
 *     leaf adj-ribs-in-routes {
 *       type yang:gauge64;
 *     }
 *     leaf loc-rib-routes {
 *       type yang:gauge64;
 *     }
 *     container per-afi-safi-adj-rib-in-routes {
 *       uses afi-safi-route-counter;
 *     }
 *     container per-afi-safi-loc-rib-routes {
 *       uses afi-safi-route-counter;
 *     }
 *     leaf updates-treated-as-withdraw {
 *       type yang:counter32;
 *     }
 *     leaf prefixes-treated-as-withdraw {
 *       type yang:counter32;
 *     }
 *     leaf duplicate-updates {
 *       type yang:counter32;
 *     }
 *     uses bmp-msg:timestamp;
 *   }
 *   container pre-policy-rib {
 *     uses rib:rib;
 *   }
 *   container post-policy-rib {
 *     uses rib:rib;
 *   }
 *   container mirrors {
 *     leaf information {
 *       type bmp-msg:mirror-information-code;
 *     }
 *     uses bmp-msg:timestamp;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/peers/peer</i>
 *
 * <p>To create instances of this class use {@link PeerBuilder}.
 * @see PeerBuilder
 * @see PeerKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Peer
    extends
    ChildOf<Peers>,
    Augmentable<Peer>,
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer,
    Identifiable<PeerKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.@NonNull Peer obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAddress());
        result = prime * result + Objects.hashCode(obj.getAs());
        result = prime * result + Objects.hashCode(obj.getBgpId());
        result = prime * result + Objects.hashCode(obj.getMirrors());
        result = prime * result + Objects.hashCode(obj.getPeerDistinguisher());
        result = prime * result + Objects.hashCode(obj.getPeerId());
        result = prime * result + Objects.hashCode(obj.getPeerSession());
        result = prime * result + Objects.hashCode(obj.getPostPolicyRib());
        result = prime * result + Objects.hashCode(obj.getPrePolicyRib());
        result = prime * result + Objects.hashCode(obj.getRouterDistinguisher());
        result = prime * result + Objects.hashCode(obj.getStats());
        result = prime * result + Objects.hashCode(obj.getType());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.@NonNull Peer thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAs(), other.getAs())) {
            return false;
        }
        if (!Objects.equals(thisObj.getBgpId(), other.getBgpId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPeerId(), other.getPeerId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRouterDistinguisher(), other.getRouterDistinguisher())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAddress(), other.getAddress())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMirrors(), other.getMirrors())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPeerDistinguisher(), other.getPeerDistinguisher())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPeerSession(), other.getPeerSession())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPostPolicyRib(), other.getPostPolicyRib())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPrePolicyRib(), other.getPrePolicyRib())) {
            return false;
        }
        if (!Objects.equals(thisObj.getStats(), other.getStats())) {
            return false;
        }
        if (!Objects.equals(thisObj.getType(), other.getType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.@NonNull Peer obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Peer");
        CodeHelpers.appendValue(helper, "address", obj.getAddress());
        CodeHelpers.appendValue(helper, "as", obj.getAs());
        CodeHelpers.appendValue(helper, "bgpId", obj.getBgpId());
        CodeHelpers.appendValue(helper, "mirrors", obj.getMirrors());
        CodeHelpers.appendValue(helper, "peerDistinguisher", obj.getPeerDistinguisher());
        CodeHelpers.appendValue(helper, "peerId", obj.getPeerId());
        CodeHelpers.appendValue(helper, "peerSession", obj.getPeerSession());
        CodeHelpers.appendValue(helper, "postPolicyRib", obj.getPostPolicyRib());
        CodeHelpers.appendValue(helper, "prePolicyRib", obj.getPrePolicyRib());
        CodeHelpers.appendValue(helper, "routerDistinguisher", obj.getRouterDistinguisher());
        CodeHelpers.appendValue(helper, "stats", obj.getStats());
        CodeHelpers.appendValue(helper, "type", obj.getType());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    @Override
    PeerKey key();
    
    /**
     * Return peerId, or {@code null} if it is not present.
     *
     * @return {@code PeerId} peerId, or {@code null} if it is not present.
     *
     */
    PeerId getPeerId();
    
    /**
     * Return peerId, guaranteed to be non-null.
     *
     * @return {@code PeerId} peerId, guaranteed to be non-null.
     * @throws NoSuchElementException if peerId is not present
     *
     */
    default @NonNull PeerId requirePeerId() {
        return CodeHelpers.require(getPeerId(), "peerid");
    }
    
    /**
     * Return routerDistinguisher, or {@code null} if it is not present.
     *
     * @return {@code String} routerDistinguisher, or {@code null} if it is not present.
     *
     */
    String getRouterDistinguisher();
    
    /**
     * Return routerDistinguisher, guaranteed to be non-null.
     *
     * @return {@code String} routerDistinguisher, guaranteed to be non-null.
     * @throws NoSuchElementException if routerDistinguisher is not present
     *
     */
    default @NonNull String requireRouterDistinguisher() {
        return CodeHelpers.require(getRouterDistinguisher(), "routerdistinguisher");
    }
    
    /**
     * Return peerSession, or {@code null} if it is not present.
     *
     * @return {@code PeerSession} peerSession, or {@code null} if it is not present.
     *
     */
    PeerSession getPeerSession();
    
    /**
     * Return stats, or {@code null} if it is not present.
     *
     * @return {@code Stats} stats, or {@code null} if it is not present.
     *
     */
    Stats getStats();
    
    /**
     * Return prePolicyRib, or {@code null} if it is not present.
     *
     * @return {@code PrePolicyRib} prePolicyRib, or {@code null} if it is not present.
     *
     */
    PrePolicyRib getPrePolicyRib();
    
    /**
     * Return postPolicyRib, or {@code null} if it is not present.
     *
     * @return {@code PostPolicyRib} postPolicyRib, or {@code null} if it is not present.
     *
     */
    PostPolicyRib getPostPolicyRib();
    
    /**
     * Return mirrors, or {@code null} if it is not present.
     *
     * @return {@code Mirrors} mirrors, or {@code null} if it is not present.
     *
     */
    Mirrors getMirrors();

}

