package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer.PeerDistinguisher;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PeerSession;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PostPolicyRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PrePolicyRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PeerBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PeerBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PeerBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PeerBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PeerBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PeerBuilder implements Builder<Peer> {

    private IpAddressNoZone _address;
    private AsNumber _as;
    private Ipv4AddressNoZone _bgpId;
    private Mirrors _mirrors;
    private PeerDistinguisher _peerDistinguisher;
    private PeerId _peerId;
    private PeerSession _peerSession;
    private PostPolicyRib _postPolicyRib;
    private PrePolicyRib _prePolicyRib;
    private String _routerDistinguisher;
    private Stats _stats;
    private PeerType _type;
    private PeerKey key;


    Map<Class<? extends Augmentation<Peer>>, Augmentation<Peer>> augmentation = Collections.emptyMap();

    public PeerBuilder() {
    }
    
    
    
    public PeerBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer arg) {
        this._type = arg.getType();
        this._peerDistinguisher = arg.getPeerDistinguisher();
        this._address = arg.getAddress();
        this._as = arg.getAs();
        this._bgpId = arg.getBgpId();
    }
    

    public PeerBuilder(Peer base) {
        Map<Class<? extends Augmentation<Peer>>, Augmentation<Peer>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._peerId = base.getPeerId();
        this._address = base.getAddress();
        this._as = base.getAs();
        this._bgpId = base.getBgpId();
        this._mirrors = base.getMirrors();
        this._peerDistinguisher = base.getPeerDistinguisher();
        this._peerSession = base.getPeerSession();
        this._postPolicyRib = base.getPostPolicyRib();
        this._prePolicyRib = base.getPrePolicyRib();
        this._routerDistinguisher = base.getRouterDistinguisher();
        this._stats = base.getStats();
        this._type = base.getType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer) {
            this._type = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer)arg).getType();
            this._peerDistinguisher = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer)arg).getPeerDistinguisher();
            this._address = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer)arg).getAddress();
            this._as = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer)arg).getAs();
            this._bgpId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer)arg).getBgpId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer]");
    }

    public PeerKey key() {
        return key;
    }
    
    public IpAddressNoZone getAddress() {
        return _address;
    }
    
    public AsNumber getAs() {
        return _as;
    }
    
    public Ipv4AddressNoZone getBgpId() {
        return _bgpId;
    }
    
    public Mirrors getMirrors() {
        return _mirrors;
    }
    
    public PeerDistinguisher getPeerDistinguisher() {
        return _peerDistinguisher;
    }
    
    public PeerId getPeerId() {
        return _peerId;
    }
    
    public PeerSession getPeerSession() {
        return _peerSession;
    }
    
    public PostPolicyRib getPostPolicyRib() {
        return _postPolicyRib;
    }
    
    public PrePolicyRib getPrePolicyRib() {
        return _prePolicyRib;
    }
    
    public String getRouterDistinguisher() {
        return _routerDistinguisher;
    }
    
    public Stats getStats() {
        return _stats;
    }
    
    public PeerType getType() {
        return _type;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Peer>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PeerBuilder withKey(final PeerKey key) {
        this.key = key;
        return this;
    }
    
    public PeerBuilder setAddress(final IpAddressNoZone value) {
        this._address = value;
        return this;
    }
    
    public PeerBuilder setAs(final AsNumber value) {
        this._as = value;
        return this;
    }
    
    public PeerBuilder setBgpId(final Ipv4AddressNoZone value) {
        this._bgpId = value;
        return this;
    }
    
    public PeerBuilder setMirrors(final Mirrors value) {
        this._mirrors = value;
        return this;
    }
    
    public PeerBuilder setPeerDistinguisher(final PeerDistinguisher value) {
        this._peerDistinguisher = value;
        return this;
    }
    
    public PeerBuilder setPeerId(final PeerId value) {
        this._peerId = value;
        return this;
    }
    
    public PeerBuilder setPeerSession(final PeerSession value) {
        this._peerSession = value;
        return this;
    }
    
    public PeerBuilder setPostPolicyRib(final PostPolicyRib value) {
        this._postPolicyRib = value;
        return this;
    }
    
    public PeerBuilder setPrePolicyRib(final PrePolicyRib value) {
        this._prePolicyRib = value;
        return this;
    }
    
    public PeerBuilder setRouterDistinguisher(final String value) {
        this._routerDistinguisher = value;
        return this;
    }
    
    public PeerBuilder setStats(final Stats value) {
        this._stats = value;
        return this;
    }
    
    public PeerBuilder setType(final PeerType value) {
        this._type = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PeerBuilder addAugmentation(Augmentation<Peer> augmentation) {
        Class<? extends Augmentation<Peer>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PeerBuilder removeAugmentation(Class<? extends Augmentation<Peer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Peer build() {
        return new PeerImpl(this);
    }

    private static final class PeerImpl
        extends AbstractAugmentable<Peer>
        implements Peer {
    
        private final IpAddressNoZone _address;
        private final AsNumber _as;
        private final Ipv4AddressNoZone _bgpId;
        private final Mirrors _mirrors;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer.PeerDistinguisher _peerDistinguisher;
        private final PeerId _peerId;
        private final PeerSession _peerSession;
        private final PostPolicyRib _postPolicyRib;
        private final PrePolicyRib _prePolicyRib;
        private final String _routerDistinguisher;
        private final Stats _stats;
        private final PeerType _type;
        private final PeerKey key;
    
        PeerImpl(PeerBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new PeerKey(base.getPeerId());
            }
            this._peerId = key.getPeerId();
            this._address = base.getAddress();
            this._as = base.getAs();
            this._bgpId = base.getBgpId();
            this._mirrors = base.getMirrors();
            this._peerDistinguisher = base.getPeerDistinguisher();
            this._peerSession = base.getPeerSession();
            this._postPolicyRib = base.getPostPolicyRib();
            this._prePolicyRib = base.getPrePolicyRib();
            this._routerDistinguisher = base.getRouterDistinguisher();
            this._stats = base.getStats();
            this._type = base.getType();
        }
    
        @Override
        public PeerKey key() {
            return key;
        }
        
        @Override
        public IpAddressNoZone getAddress() {
            return _address;
        }
        
        @Override
        public AsNumber getAs() {
            return _as;
        }
        
        @Override
        public Ipv4AddressNoZone getBgpId() {
            return _bgpId;
        }
        
        @Override
        public Mirrors getMirrors() {
            return _mirrors;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer.PeerDistinguisher getPeerDistinguisher() {
            return _peerDistinguisher;
        }
        
        @Override
        public PeerId getPeerId() {
            return _peerId;
        }
        
        @Override
        public PeerSession getPeerSession() {
            return _peerSession;
        }
        
        @Override
        public PostPolicyRib getPostPolicyRib() {
            return _postPolicyRib;
        }
        
        @Override
        public PrePolicyRib getPrePolicyRib() {
            return _prePolicyRib;
        }
        
        @Override
        public String getRouterDistinguisher() {
            return _routerDistinguisher;
        }
        
        @Override
        public Stats getStats() {
            return _stats;
        }
        
        @Override
        public PeerType getType() {
            return _type;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Peer.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Peer.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Peer.bindingToString(this);
        }
    }
}
