package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.MirrorInformationCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * container mirrors {
 *   leaf information {
 *     type bmp-msg:mirror-information-code;
 *   }
 *   uses bmp-msg:timestamp;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/peers/peer/mirrors</i>
 *
 * <p>To create instances of this class use {@link MirrorsBuilder}.
 * @see MirrorsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Mirrors
    extends
    ChildOf<Peer>,
    Augmentable<Mirrors>,
    Timestamp
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mirrors");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.@NonNull Mirrors obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getInformation());
        result = prime * result + Objects.hashCode(obj.getTimestampMicro());
        result = prime * result + Objects.hashCode(obj.getTimestampSec());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.@NonNull Mirrors thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimestampMicro(), other.getTimestampMicro())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimestampSec(), other.getTimestampSec())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInformation(), other.getInformation())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.@NonNull Mirrors obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Mirrors");
        CodeHelpers.appendValue(helper, "information", obj.getInformation());
        CodeHelpers.appendValue(helper, "timestampMicro", obj.getTimestampMicro());
        CodeHelpers.appendValue(helper, "timestampSec", obj.getTimestampSec());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return information, or {@code null} if it is not present.
     *
     * @return {@code MirrorInformationCode} information, or {@code null} if it is not present.
     *
     */
    MirrorInformationCode getInformation();
    
    /**
     * Return information, guaranteed to be non-null.
     *
     * @return {@code MirrorInformationCode} information, guaranteed to be non-null.
     * @throws NoSuchElementException if information is not present
     *
     */
    default @NonNull MirrorInformationCode requireInformation() {
        return CodeHelpers.require(getInformation(), "information");
    }

}

