package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.Information;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.ReceivedOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Status;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PeerSessionBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PeerSessionBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PeerSessionBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PeerSessionBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PeerSessionBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PeerSessionBuilder implements Builder<PeerSession> {

    private Information _information;
    private IpAddressNoZone _localAddress;
    private PortNumber _localPort;
    private ReceivedOpen _receivedOpen;
    private PortNumber _remotePort;
    private SentOpen _sentOpen;
    private Status _status;
    private Timestamp _timestampMicro;
    private Timestamp _timestampSec;


    Map<Class<? extends Augmentation<PeerSession>>, Augmentation<PeerSession>> augmentation = Collections.emptyMap();

    public PeerSessionBuilder() {
    }
    
    
    
    public PeerSessionBuilder(PeerUp arg) {
        this._localAddress = arg.getLocalAddress();
        this._localPort = arg.getLocalPort();
        this._remotePort = arg.getRemotePort();
        this._sentOpen = arg.getSentOpen();
        this._receivedOpen = arg.getReceivedOpen();
        this._information = arg.getInformation();
    }
    
    public PeerSessionBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp arg) {
        this._timestampSec = arg.getTimestampSec();
        this._timestampMicro = arg.getTimestampMicro();
    }

    public PeerSessionBuilder(PeerSession base) {
        Map<Class<? extends Augmentation<PeerSession>>, Augmentation<PeerSession>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._information = base.getInformation();
        this._localAddress = base.getLocalAddress();
        this._localPort = base.getLocalPort();
        this._receivedOpen = base.getReceivedOpen();
        this._remotePort = base.getRemotePort();
        this._sentOpen = base.getSentOpen();
        this._status = base.getStatus();
        this._timestampMicro = base.getTimestampMicro();
        this._timestampSec = base.getTimestampSec();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>PeerUp</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PeerUp) {
            this._localAddress = ((PeerUp)arg).getLocalAddress();
            this._localPort = ((PeerUp)arg).getLocalPort();
            this._remotePort = ((PeerUp)arg).getRemotePort();
            this._sentOpen = ((PeerUp)arg).getSentOpen();
            this._receivedOpen = ((PeerUp)arg).getReceivedOpen();
            this._information = ((PeerUp)arg).getInformation();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp) {
            this._timestampSec = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp)arg).getTimestampSec();
            this._timestampMicro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp)arg).getTimestampMicro();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PeerUp, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp]");
    }

    public Information getInformation() {
        return _information;
    }
    
    public IpAddressNoZone getLocalAddress() {
        return _localAddress;
    }
    
    public PortNumber getLocalPort() {
        return _localPort;
    }
    
    public ReceivedOpen getReceivedOpen() {
        return _receivedOpen;
    }
    
    public PortNumber getRemotePort() {
        return _remotePort;
    }
    
    public SentOpen getSentOpen() {
        return _sentOpen;
    }
    
    public Status getStatus() {
        return _status;
    }
    
    public Timestamp getTimestampMicro() {
        return _timestampMicro;
    }
    
    public Timestamp getTimestampSec() {
        return _timestampSec;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PeerSession>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PeerSessionBuilder setInformation(final Information value) {
        this._information = value;
        return this;
    }
    
    public PeerSessionBuilder setLocalAddress(final IpAddressNoZone value) {
        this._localAddress = value;
        return this;
    }
    
    public PeerSessionBuilder setLocalPort(final PortNumber value) {
        this._localPort = value;
        return this;
    }
    
    public PeerSessionBuilder setReceivedOpen(final ReceivedOpen value) {
        this._receivedOpen = value;
        return this;
    }
    
    public PeerSessionBuilder setRemotePort(final PortNumber value) {
        this._remotePort = value;
        return this;
    }
    
    public PeerSessionBuilder setSentOpen(final SentOpen value) {
        this._sentOpen = value;
        return this;
    }
    
    public PeerSessionBuilder setStatus(final Status value) {
        this._status = value;
        return this;
    }
    
    public PeerSessionBuilder setTimestampMicro(final Timestamp value) {
        this._timestampMicro = value;
        return this;
    }
    
    public PeerSessionBuilder setTimestampSec(final Timestamp value) {
        this._timestampSec = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PeerSessionBuilder addAugmentation(Augmentation<PeerSession> augmentation) {
        Class<? extends Augmentation<PeerSession>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PeerSessionBuilder removeAugmentation(Class<? extends Augmentation<PeerSession>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PeerSession build() {
        return new PeerSessionImpl(this);
    }

    private static final class PeerSessionImpl
        extends AbstractAugmentable<PeerSession>
        implements PeerSession {
    
        private final Information _information;
        private final IpAddressNoZone _localAddress;
        private final PortNumber _localPort;
        private final ReceivedOpen _receivedOpen;
        private final PortNumber _remotePort;
        private final SentOpen _sentOpen;
        private final Status _status;
        private final Timestamp _timestampMicro;
        private final Timestamp _timestampSec;
    
        PeerSessionImpl(PeerSessionBuilder base) {
            super(base.augmentation);
            this._information = base.getInformation();
            this._localAddress = base.getLocalAddress();
            this._localPort = base.getLocalPort();
            this._receivedOpen = base.getReceivedOpen();
            this._remotePort = base.getRemotePort();
            this._sentOpen = base.getSentOpen();
            this._status = base.getStatus();
            this._timestampMicro = base.getTimestampMicro();
            this._timestampSec = base.getTimestampSec();
        }
    
        @Override
        public Information getInformation() {
            return _information;
        }
        
        @Override
        public IpAddressNoZone getLocalAddress() {
            return _localAddress;
        }
        
        @Override
        public PortNumber getLocalPort() {
            return _localPort;
        }
        
        @Override
        public ReceivedOpen getReceivedOpen() {
            return _receivedOpen;
        }
        
        @Override
        public PortNumber getRemotePort() {
            return _remotePort;
        }
        
        @Override
        public SentOpen getSentOpen() {
            return _sentOpen;
        }
        
        @Override
        public Status getStatus() {
            return _status;
        }
        
        @Override
        public Timestamp getTimestampMicro() {
            return _timestampMicro;
        }
        
        @Override
        public Timestamp getTimestampSec() {
            return _timestampSec;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PeerSession.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PeerSession.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PeerSession.bindingToString(this);
        }
    }
}
