package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.stats.PerAfiSafiAdjRibInRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.stats.PerAfiSafiLocRibRoutes;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * container stats {
 *   leaf rejected-prefixes {
 *     type yang:counter32;
 *   }
 *   leaf duplicate-prefix-advertisements {
 *     type yang:counter32;
 *   }
 *   leaf duplicate-withdraws {
 *     type yang:counter32;
 *   }
 *   leaf invalidated-cluster-list-loop {
 *     type yang:counter32;
 *   }
 *   leaf invalidated-as-path-loop {
 *     type yang:counter32;
 *   }
 *   leaf invalidated-originator-id {
 *     type yang:counter32;
 *   }
 *   leaf invalidated-as-confed-loop {
 *     type yang:counter32;
 *   }
 *   leaf adj-ribs-in-routes {
 *     type yang:gauge64;
 *   }
 *   leaf loc-rib-routes {
 *     type yang:gauge64;
 *   }
 *   container per-afi-safi-adj-rib-in-routes {
 *     uses afi-safi-route-counter;
 *   }
 *   container per-afi-safi-loc-rib-routes {
 *     uses afi-safi-route-counter;
 *   }
 *   leaf updates-treated-as-withdraw {
 *     type yang:counter32;
 *   }
 *   leaf prefixes-treated-as-withdraw {
 *     type yang:counter32;
 *   }
 *   leaf duplicate-updates {
 *     type yang:counter32;
 *   }
 *   uses bmp-msg:timestamp;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/peers/peer/stats</i>
 *
 * <p>To create instances of this class use {@link StatsBuilder}.
 * @see StatsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Stats
    extends
    ChildOf<Peer>,
    Augmentable<Stats>,
    Timestamp
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("stats");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.@NonNull Stats obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAdjRibsInRoutes());
        result = prime * result + Objects.hashCode(obj.getDuplicatePrefixAdvertisements());
        result = prime * result + Objects.hashCode(obj.getDuplicateUpdates());
        result = prime * result + Objects.hashCode(obj.getDuplicateWithdraws());
        result = prime * result + Objects.hashCode(obj.getInvalidatedAsConfedLoop());
        result = prime * result + Objects.hashCode(obj.getInvalidatedAsPathLoop());
        result = prime * result + Objects.hashCode(obj.getInvalidatedClusterListLoop());
        result = prime * result + Objects.hashCode(obj.getInvalidatedOriginatorId());
        result = prime * result + Objects.hashCode(obj.getLocRibRoutes());
        result = prime * result + Objects.hashCode(obj.getPerAfiSafiAdjRibInRoutes());
        result = prime * result + Objects.hashCode(obj.getPerAfiSafiLocRibRoutes());
        result = prime * result + Objects.hashCode(obj.getPrefixesTreatedAsWithdraw());
        result = prime * result + Objects.hashCode(obj.getRejectedPrefixes());
        result = prime * result + Objects.hashCode(obj.getTimestampMicro());
        result = prime * result + Objects.hashCode(obj.getTimestampSec());
        result = prime * result + Objects.hashCode(obj.getUpdatesTreatedAsWithdraw());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.@NonNull Stats thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAdjRibsInRoutes(), other.getAdjRibsInRoutes())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDuplicatePrefixAdvertisements(), other.getDuplicatePrefixAdvertisements())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDuplicateUpdates(), other.getDuplicateUpdates())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDuplicateWithdraws(), other.getDuplicateWithdraws())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInvalidatedAsConfedLoop(), other.getInvalidatedAsConfedLoop())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInvalidatedAsPathLoop(), other.getInvalidatedAsPathLoop())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInvalidatedClusterListLoop(), other.getInvalidatedClusterListLoop())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInvalidatedOriginatorId(), other.getInvalidatedOriginatorId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLocRibRoutes(), other.getLocRibRoutes())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPrefixesTreatedAsWithdraw(), other.getPrefixesTreatedAsWithdraw())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRejectedPrefixes(), other.getRejectedPrefixes())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimestampMicro(), other.getTimestampMicro())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimestampSec(), other.getTimestampSec())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUpdatesTreatedAsWithdraw(), other.getUpdatesTreatedAsWithdraw())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPerAfiSafiAdjRibInRoutes(), other.getPerAfiSafiAdjRibInRoutes())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPerAfiSafiLocRibRoutes(), other.getPerAfiSafiLocRibRoutes())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.@NonNull Stats obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Stats");
        CodeHelpers.appendValue(helper, "adjRibsInRoutes", obj.getAdjRibsInRoutes());
        CodeHelpers.appendValue(helper, "duplicatePrefixAdvertisements", obj.getDuplicatePrefixAdvertisements());
        CodeHelpers.appendValue(helper, "duplicateUpdates", obj.getDuplicateUpdates());
        CodeHelpers.appendValue(helper, "duplicateWithdraws", obj.getDuplicateWithdraws());
        CodeHelpers.appendValue(helper, "invalidatedAsConfedLoop", obj.getInvalidatedAsConfedLoop());
        CodeHelpers.appendValue(helper, "invalidatedAsPathLoop", obj.getInvalidatedAsPathLoop());
        CodeHelpers.appendValue(helper, "invalidatedClusterListLoop", obj.getInvalidatedClusterListLoop());
        CodeHelpers.appendValue(helper, "invalidatedOriginatorId", obj.getInvalidatedOriginatorId());
        CodeHelpers.appendValue(helper, "locRibRoutes", obj.getLocRibRoutes());
        CodeHelpers.appendValue(helper, "perAfiSafiAdjRibInRoutes", obj.getPerAfiSafiAdjRibInRoutes());
        CodeHelpers.appendValue(helper, "perAfiSafiLocRibRoutes", obj.getPerAfiSafiLocRibRoutes());
        CodeHelpers.appendValue(helper, "prefixesTreatedAsWithdraw", obj.getPrefixesTreatedAsWithdraw());
        CodeHelpers.appendValue(helper, "rejectedPrefixes", obj.getRejectedPrefixes());
        CodeHelpers.appendValue(helper, "timestampMicro", obj.getTimestampMicro());
        CodeHelpers.appendValue(helper, "timestampSec", obj.getTimestampSec());
        CodeHelpers.appendValue(helper, "updatesTreatedAsWithdraw", obj.getUpdatesTreatedAsWithdraw());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return rejectedPrefixes, or {@code null} if it is not present.
     *
     * @return {@code Counter32} rejectedPrefixes, or {@code null} if it is not present.
     *
     */
    Counter32 getRejectedPrefixes();
    
    /**
     * Return rejectedPrefixes, guaranteed to be non-null.
     *
     * @return {@code Counter32} rejectedPrefixes, guaranteed to be non-null.
     * @throws NoSuchElementException if rejectedPrefixes is not present
     *
     */
    default @NonNull Counter32 requireRejectedPrefixes() {
        return CodeHelpers.require(getRejectedPrefixes(), "rejectedprefixes");
    }
    
    /**
     * Return duplicatePrefixAdvertisements, or {@code null} if it is not present.
     *
     * @return {@code Counter32} duplicatePrefixAdvertisements, or {@code null} if it is not present.
     *
     */
    Counter32 getDuplicatePrefixAdvertisements();
    
    /**
     * Return duplicatePrefixAdvertisements, guaranteed to be non-null.
     *
     * @return {@code Counter32} duplicatePrefixAdvertisements, guaranteed to be non-null.
     * @throws NoSuchElementException if duplicatePrefixAdvertisements is not present
     *
     */
    default @NonNull Counter32 requireDuplicatePrefixAdvertisements() {
        return CodeHelpers.require(getDuplicatePrefixAdvertisements(), "duplicateprefixadvertisements");
    }
    
    /**
     * Return duplicateWithdraws, or {@code null} if it is not present.
     *
     * @return {@code Counter32} duplicateWithdraws, or {@code null} if it is not present.
     *
     */
    Counter32 getDuplicateWithdraws();
    
    /**
     * Return duplicateWithdraws, guaranteed to be non-null.
     *
     * @return {@code Counter32} duplicateWithdraws, guaranteed to be non-null.
     * @throws NoSuchElementException if duplicateWithdraws is not present
     *
     */
    default @NonNull Counter32 requireDuplicateWithdraws() {
        return CodeHelpers.require(getDuplicateWithdraws(), "duplicatewithdraws");
    }
    
    /**
     * Return invalidatedClusterListLoop, or {@code null} if it is not present.
     *
     * @return {@code Counter32} invalidatedClusterListLoop, or {@code null} if it is not present.
     *
     */
    Counter32 getInvalidatedClusterListLoop();
    
    /**
     * Return invalidatedClusterListLoop, guaranteed to be non-null.
     *
     * @return {@code Counter32} invalidatedClusterListLoop, guaranteed to be non-null.
     * @throws NoSuchElementException if invalidatedClusterListLoop is not present
     *
     */
    default @NonNull Counter32 requireInvalidatedClusterListLoop() {
        return CodeHelpers.require(getInvalidatedClusterListLoop(), "invalidatedclusterlistloop");
    }
    
    /**
     * Return invalidatedAsPathLoop, or {@code null} if it is not present.
     *
     * @return {@code Counter32} invalidatedAsPathLoop, or {@code null} if it is not present.
     *
     */
    Counter32 getInvalidatedAsPathLoop();
    
    /**
     * Return invalidatedAsPathLoop, guaranteed to be non-null.
     *
     * @return {@code Counter32} invalidatedAsPathLoop, guaranteed to be non-null.
     * @throws NoSuchElementException if invalidatedAsPathLoop is not present
     *
     */
    default @NonNull Counter32 requireInvalidatedAsPathLoop() {
        return CodeHelpers.require(getInvalidatedAsPathLoop(), "invalidatedaspathloop");
    }
    
    /**
     * Return invalidatedOriginatorId, or {@code null} if it is not present.
     *
     * @return {@code Counter32} invalidatedOriginatorId, or {@code null} if it is not present.
     *
     */
    Counter32 getInvalidatedOriginatorId();
    
    /**
     * Return invalidatedOriginatorId, guaranteed to be non-null.
     *
     * @return {@code Counter32} invalidatedOriginatorId, guaranteed to be non-null.
     * @throws NoSuchElementException if invalidatedOriginatorId is not present
     *
     */
    default @NonNull Counter32 requireInvalidatedOriginatorId() {
        return CodeHelpers.require(getInvalidatedOriginatorId(), "invalidatedoriginatorid");
    }
    
    /**
     * Return invalidatedAsConfedLoop, or {@code null} if it is not present.
     *
     * @return {@code Counter32} invalidatedAsConfedLoop, or {@code null} if it is not present.
     *
     */
    Counter32 getInvalidatedAsConfedLoop();
    
    /**
     * Return invalidatedAsConfedLoop, guaranteed to be non-null.
     *
     * @return {@code Counter32} invalidatedAsConfedLoop, guaranteed to be non-null.
     * @throws NoSuchElementException if invalidatedAsConfedLoop is not present
     *
     */
    default @NonNull Counter32 requireInvalidatedAsConfedLoop() {
        return CodeHelpers.require(getInvalidatedAsConfedLoop(), "invalidatedasconfedloop");
    }
    
    /**
     * Return adjRibsInRoutes, or {@code null} if it is not present.
     *
     * @return {@code Gauge64} adjRibsInRoutes, or {@code null} if it is not present.
     *
     */
    Gauge64 getAdjRibsInRoutes();
    
    /**
     * Return adjRibsInRoutes, guaranteed to be non-null.
     *
     * @return {@code Gauge64} adjRibsInRoutes, guaranteed to be non-null.
     * @throws NoSuchElementException if adjRibsInRoutes is not present
     *
     */
    default @NonNull Gauge64 requireAdjRibsInRoutes() {
        return CodeHelpers.require(getAdjRibsInRoutes(), "adjribsinroutes");
    }
    
    /**
     * Return locRibRoutes, or {@code null} if it is not present.
     *
     * @return {@code Gauge64} locRibRoutes, or {@code null} if it is not present.
     *
     */
    Gauge64 getLocRibRoutes();
    
    /**
     * Return locRibRoutes, guaranteed to be non-null.
     *
     * @return {@code Gauge64} locRibRoutes, guaranteed to be non-null.
     * @throws NoSuchElementException if locRibRoutes is not present
     *
     */
    default @NonNull Gauge64 requireLocRibRoutes() {
        return CodeHelpers.require(getLocRibRoutes(), "locribroutes");
    }
    
    /**
     * Return perAfiSafiAdjRibInRoutes, or {@code null} if it is not present.
     *
     * @return {@code PerAfiSafiAdjRibInRoutes} perAfiSafiAdjRibInRoutes, or {@code null} if it is not present.
     *
     */
    PerAfiSafiAdjRibInRoutes getPerAfiSafiAdjRibInRoutes();
    
    /**
     * Return perAfiSafiLocRibRoutes, or {@code null} if it is not present.
     *
     * @return {@code PerAfiSafiLocRibRoutes} perAfiSafiLocRibRoutes, or {@code null} if it is not present.
     *
     */
    PerAfiSafiLocRibRoutes getPerAfiSafiLocRibRoutes();
    
    /**
     * Return updatesTreatedAsWithdraw, or {@code null} if it is not present.
     *
     * @return {@code Counter32} updatesTreatedAsWithdraw, or {@code null} if it is not present.
     *
     */
    Counter32 getUpdatesTreatedAsWithdraw();
    
    /**
     * Return updatesTreatedAsWithdraw, guaranteed to be non-null.
     *
     * @return {@code Counter32} updatesTreatedAsWithdraw, guaranteed to be non-null.
     * @throws NoSuchElementException if updatesTreatedAsWithdraw is not present
     *
     */
    default @NonNull Counter32 requireUpdatesTreatedAsWithdraw() {
        return CodeHelpers.require(getUpdatesTreatedAsWithdraw(), "updatestreatedaswithdraw");
    }
    
    /**
     * Return prefixesTreatedAsWithdraw, or {@code null} if it is not present.
     *
     * @return {@code Counter32} prefixesTreatedAsWithdraw, or {@code null} if it is not present.
     *
     */
    Counter32 getPrefixesTreatedAsWithdraw();
    
    /**
     * Return prefixesTreatedAsWithdraw, guaranteed to be non-null.
     *
     * @return {@code Counter32} prefixesTreatedAsWithdraw, guaranteed to be non-null.
     * @throws NoSuchElementException if prefixesTreatedAsWithdraw is not present
     *
     */
    default @NonNull Counter32 requirePrefixesTreatedAsWithdraw() {
        return CodeHelpers.require(getPrefixesTreatedAsWithdraw(), "prefixestreatedaswithdraw");
    }
    
    /**
     * Return duplicateUpdates, or {@code null} if it is not present.
     *
     * @return {@code Counter32} duplicateUpdates, or {@code null} if it is not present.
     *
     */
    Counter32 getDuplicateUpdates();
    
    /**
     * Return duplicateUpdates, guaranteed to be non-null.
     *
     * @return {@code Counter32} duplicateUpdates, guaranteed to be non-null.
     * @throws NoSuchElementException if duplicateUpdates is not present
     *
     */
    default @NonNull Counter32 requireDuplicateUpdates() {
        return CodeHelpers.require(getDuplicateUpdates(), "duplicateupdates");
    }

}

