package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.stats.PerAfiSafiAdjRibInRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.stats.PerAfiSafiLocRibRoutes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link StatsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     StatsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new StatsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of StatsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see StatsBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class StatsBuilder implements Builder<Stats> {

    private Gauge64 _adjRibsInRoutes;
    private Counter32 _duplicatePrefixAdvertisements;
    private Counter32 _duplicateUpdates;
    private Counter32 _duplicateWithdraws;
    private Counter32 _invalidatedAsConfedLoop;
    private Counter32 _invalidatedAsPathLoop;
    private Counter32 _invalidatedClusterListLoop;
    private Counter32 _invalidatedOriginatorId;
    private Gauge64 _locRibRoutes;
    private PerAfiSafiAdjRibInRoutes _perAfiSafiAdjRibInRoutes;
    private PerAfiSafiLocRibRoutes _perAfiSafiLocRibRoutes;
    private Counter32 _prefixesTreatedAsWithdraw;
    private Counter32 _rejectedPrefixes;
    private Timestamp _timestampMicro;
    private Timestamp _timestampSec;
    private Counter32 _updatesTreatedAsWithdraw;


    Map<Class<? extends Augmentation<Stats>>, Augmentation<Stats>> augmentation = Collections.emptyMap();

    public StatsBuilder() {
    }
    
    
    
    public StatsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp arg) {
        this._timestampSec = arg.getTimestampSec();
        this._timestampMicro = arg.getTimestampMicro();
    }

    public StatsBuilder(Stats base) {
        Map<Class<? extends Augmentation<Stats>>, Augmentation<Stats>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._adjRibsInRoutes = base.getAdjRibsInRoutes();
        this._duplicatePrefixAdvertisements = base.getDuplicatePrefixAdvertisements();
        this._duplicateUpdates = base.getDuplicateUpdates();
        this._duplicateWithdraws = base.getDuplicateWithdraws();
        this._invalidatedAsConfedLoop = base.getInvalidatedAsConfedLoop();
        this._invalidatedAsPathLoop = base.getInvalidatedAsPathLoop();
        this._invalidatedClusterListLoop = base.getInvalidatedClusterListLoop();
        this._invalidatedOriginatorId = base.getInvalidatedOriginatorId();
        this._locRibRoutes = base.getLocRibRoutes();
        this._perAfiSafiAdjRibInRoutes = base.getPerAfiSafiAdjRibInRoutes();
        this._perAfiSafiLocRibRoutes = base.getPerAfiSafiLocRibRoutes();
        this._prefixesTreatedAsWithdraw = base.getPrefixesTreatedAsWithdraw();
        this._rejectedPrefixes = base.getRejectedPrefixes();
        this._timestampMicro = base.getTimestampMicro();
        this._timestampSec = base.getTimestampSec();
        this._updatesTreatedAsWithdraw = base.getUpdatesTreatedAsWithdraw();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp) {
            this._timestampSec = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp)arg).getTimestampSec();
            this._timestampMicro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp)arg).getTimestampMicro();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp]");
    }

    public Gauge64 getAdjRibsInRoutes() {
        return _adjRibsInRoutes;
    }
    
    public Counter32 getDuplicatePrefixAdvertisements() {
        return _duplicatePrefixAdvertisements;
    }
    
    public Counter32 getDuplicateUpdates() {
        return _duplicateUpdates;
    }
    
    public Counter32 getDuplicateWithdraws() {
        return _duplicateWithdraws;
    }
    
    public Counter32 getInvalidatedAsConfedLoop() {
        return _invalidatedAsConfedLoop;
    }
    
    public Counter32 getInvalidatedAsPathLoop() {
        return _invalidatedAsPathLoop;
    }
    
    public Counter32 getInvalidatedClusterListLoop() {
        return _invalidatedClusterListLoop;
    }
    
    public Counter32 getInvalidatedOriginatorId() {
        return _invalidatedOriginatorId;
    }
    
    public Gauge64 getLocRibRoutes() {
        return _locRibRoutes;
    }
    
    public PerAfiSafiAdjRibInRoutes getPerAfiSafiAdjRibInRoutes() {
        return _perAfiSafiAdjRibInRoutes;
    }
    
    public PerAfiSafiLocRibRoutes getPerAfiSafiLocRibRoutes() {
        return _perAfiSafiLocRibRoutes;
    }
    
    public Counter32 getPrefixesTreatedAsWithdraw() {
        return _prefixesTreatedAsWithdraw;
    }
    
    public Counter32 getRejectedPrefixes() {
        return _rejectedPrefixes;
    }
    
    public Timestamp getTimestampMicro() {
        return _timestampMicro;
    }
    
    public Timestamp getTimestampSec() {
        return _timestampSec;
    }
    
    public Counter32 getUpdatesTreatedAsWithdraw() {
        return _updatesTreatedAsWithdraw;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Stats>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public StatsBuilder setAdjRibsInRoutes(final Gauge64 value) {
        this._adjRibsInRoutes = value;
        return this;
    }
    
    public StatsBuilder setDuplicatePrefixAdvertisements(final Counter32 value) {
        this._duplicatePrefixAdvertisements = value;
        return this;
    }
    
    public StatsBuilder setDuplicateUpdates(final Counter32 value) {
        this._duplicateUpdates = value;
        return this;
    }
    
    public StatsBuilder setDuplicateWithdraws(final Counter32 value) {
        this._duplicateWithdraws = value;
        return this;
    }
    
    public StatsBuilder setInvalidatedAsConfedLoop(final Counter32 value) {
        this._invalidatedAsConfedLoop = value;
        return this;
    }
    
    public StatsBuilder setInvalidatedAsPathLoop(final Counter32 value) {
        this._invalidatedAsPathLoop = value;
        return this;
    }
    
    public StatsBuilder setInvalidatedClusterListLoop(final Counter32 value) {
        this._invalidatedClusterListLoop = value;
        return this;
    }
    
    public StatsBuilder setInvalidatedOriginatorId(final Counter32 value) {
        this._invalidatedOriginatorId = value;
        return this;
    }
    
    public StatsBuilder setLocRibRoutes(final Gauge64 value) {
        this._locRibRoutes = value;
        return this;
    }
    
    public StatsBuilder setPerAfiSafiAdjRibInRoutes(final PerAfiSafiAdjRibInRoutes value) {
        this._perAfiSafiAdjRibInRoutes = value;
        return this;
    }
    
    public StatsBuilder setPerAfiSafiLocRibRoutes(final PerAfiSafiLocRibRoutes value) {
        this._perAfiSafiLocRibRoutes = value;
        return this;
    }
    
    public StatsBuilder setPrefixesTreatedAsWithdraw(final Counter32 value) {
        this._prefixesTreatedAsWithdraw = value;
        return this;
    }
    
    public StatsBuilder setRejectedPrefixes(final Counter32 value) {
        this._rejectedPrefixes = value;
        return this;
    }
    
    public StatsBuilder setTimestampMicro(final Timestamp value) {
        this._timestampMicro = value;
        return this;
    }
    
    public StatsBuilder setTimestampSec(final Timestamp value) {
        this._timestampSec = value;
        return this;
    }
    
    public StatsBuilder setUpdatesTreatedAsWithdraw(final Counter32 value) {
        this._updatesTreatedAsWithdraw = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StatsBuilder addAugmentation(Augmentation<Stats> augmentation) {
        Class<? extends Augmentation<Stats>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StatsBuilder removeAugmentation(Class<? extends Augmentation<Stats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Stats build() {
        return new StatsImpl(this);
    }

    private static final class StatsImpl
        extends AbstractAugmentable<Stats>
        implements Stats {
    
        private final Gauge64 _adjRibsInRoutes;
        private final Counter32 _duplicatePrefixAdvertisements;
        private final Counter32 _duplicateUpdates;
        private final Counter32 _duplicateWithdraws;
        private final Counter32 _invalidatedAsConfedLoop;
        private final Counter32 _invalidatedAsPathLoop;
        private final Counter32 _invalidatedClusterListLoop;
        private final Counter32 _invalidatedOriginatorId;
        private final Gauge64 _locRibRoutes;
        private final PerAfiSafiAdjRibInRoutes _perAfiSafiAdjRibInRoutes;
        private final PerAfiSafiLocRibRoutes _perAfiSafiLocRibRoutes;
        private final Counter32 _prefixesTreatedAsWithdraw;
        private final Counter32 _rejectedPrefixes;
        private final Timestamp _timestampMicro;
        private final Timestamp _timestampSec;
        private final Counter32 _updatesTreatedAsWithdraw;
    
        StatsImpl(StatsBuilder base) {
            super(base.augmentation);
            this._adjRibsInRoutes = base.getAdjRibsInRoutes();
            this._duplicatePrefixAdvertisements = base.getDuplicatePrefixAdvertisements();
            this._duplicateUpdates = base.getDuplicateUpdates();
            this._duplicateWithdraws = base.getDuplicateWithdraws();
            this._invalidatedAsConfedLoop = base.getInvalidatedAsConfedLoop();
            this._invalidatedAsPathLoop = base.getInvalidatedAsPathLoop();
            this._invalidatedClusterListLoop = base.getInvalidatedClusterListLoop();
            this._invalidatedOriginatorId = base.getInvalidatedOriginatorId();
            this._locRibRoutes = base.getLocRibRoutes();
            this._perAfiSafiAdjRibInRoutes = base.getPerAfiSafiAdjRibInRoutes();
            this._perAfiSafiLocRibRoutes = base.getPerAfiSafiLocRibRoutes();
            this._prefixesTreatedAsWithdraw = base.getPrefixesTreatedAsWithdraw();
            this._rejectedPrefixes = base.getRejectedPrefixes();
            this._timestampMicro = base.getTimestampMicro();
            this._timestampSec = base.getTimestampSec();
            this._updatesTreatedAsWithdraw = base.getUpdatesTreatedAsWithdraw();
        }
    
        @Override
        public Gauge64 getAdjRibsInRoutes() {
            return _adjRibsInRoutes;
        }
        
        @Override
        public Counter32 getDuplicatePrefixAdvertisements() {
            return _duplicatePrefixAdvertisements;
        }
        
        @Override
        public Counter32 getDuplicateUpdates() {
            return _duplicateUpdates;
        }
        
        @Override
        public Counter32 getDuplicateWithdraws() {
            return _duplicateWithdraws;
        }
        
        @Override
        public Counter32 getInvalidatedAsConfedLoop() {
            return _invalidatedAsConfedLoop;
        }
        
        @Override
        public Counter32 getInvalidatedAsPathLoop() {
            return _invalidatedAsPathLoop;
        }
        
        @Override
        public Counter32 getInvalidatedClusterListLoop() {
            return _invalidatedClusterListLoop;
        }
        
        @Override
        public Counter32 getInvalidatedOriginatorId() {
            return _invalidatedOriginatorId;
        }
        
        @Override
        public Gauge64 getLocRibRoutes() {
            return _locRibRoutes;
        }
        
        @Override
        public PerAfiSafiAdjRibInRoutes getPerAfiSafiAdjRibInRoutes() {
            return _perAfiSafiAdjRibInRoutes;
        }
        
        @Override
        public PerAfiSafiLocRibRoutes getPerAfiSafiLocRibRoutes() {
            return _perAfiSafiLocRibRoutes;
        }
        
        @Override
        public Counter32 getPrefixesTreatedAsWithdraw() {
            return _prefixesTreatedAsWithdraw;
        }
        
        @Override
        public Counter32 getRejectedPrefixes() {
            return _rejectedPrefixes;
        }
        
        @Override
        public Timestamp getTimestampMicro() {
            return _timestampMicro;
        }
        
        @Override
        public Timestamp getTimestampSec() {
            return _timestampSec;
        }
        
        @Override
        public Counter32 getUpdatesTreatedAsWithdraw() {
            return _updatesTreatedAsWithdraw;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Stats.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Stats.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Stats.bindingToString(this);
        }
    }
}
