package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.stats;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.AfiSafiRouteCounter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.AfiSafi;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.AfiSafiKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PerAfiSafiAdjRibInRoutesBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PerAfiSafiAdjRibInRoutesBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PerAfiSafiAdjRibInRoutesBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PerAfiSafiAdjRibInRoutesBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PerAfiSafiAdjRibInRoutesBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PerAfiSafiAdjRibInRoutesBuilder implements Builder<PerAfiSafiAdjRibInRoutes> {

    private Map<AfiSafiKey, AfiSafi> _afiSafi;


    Map<Class<? extends Augmentation<PerAfiSafiAdjRibInRoutes>>, Augmentation<PerAfiSafiAdjRibInRoutes>> augmentation = Collections.emptyMap();

    public PerAfiSafiAdjRibInRoutesBuilder() {
    }
    
    
    
    public PerAfiSafiAdjRibInRoutesBuilder(AfiSafiRouteCounter arg) {
        this._afiSafi = arg.getAfiSafi();
    }

    public PerAfiSafiAdjRibInRoutesBuilder(PerAfiSafiAdjRibInRoutes base) {
        Map<Class<? extends Augmentation<PerAfiSafiAdjRibInRoutes>>, Augmentation<PerAfiSafiAdjRibInRoutes>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._afiSafi = base.getAfiSafi();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>AfiSafiRouteCounter</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AfiSafiRouteCounter) {
            this._afiSafi = ((AfiSafiRouteCounter)arg).getAfiSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AfiSafiRouteCounter]");
    }

    public Map<AfiSafiKey, AfiSafi> getAfiSafi() {
        return _afiSafi;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PerAfiSafiAdjRibInRoutes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PerAfiSafiAdjRibInRoutesBuilder setAfiSafi(final Map<AfiSafiKey, AfiSafi> values) {
        this._afiSafi = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PerAfiSafiAdjRibInRoutesBuilder addAugmentation(Augmentation<PerAfiSafiAdjRibInRoutes> augmentation) {
        Class<? extends Augmentation<PerAfiSafiAdjRibInRoutes>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PerAfiSafiAdjRibInRoutesBuilder removeAugmentation(Class<? extends Augmentation<PerAfiSafiAdjRibInRoutes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PerAfiSafiAdjRibInRoutes build() {
        return new PerAfiSafiAdjRibInRoutesImpl(this);
    }

    private static final class PerAfiSafiAdjRibInRoutesImpl
        extends AbstractAugmentable<PerAfiSafiAdjRibInRoutes>
        implements PerAfiSafiAdjRibInRoutes {
    
        private final Map<AfiSafiKey, AfiSafi> _afiSafi;
    
        PerAfiSafiAdjRibInRoutesImpl(PerAfiSafiAdjRibInRoutesBuilder base) {
            super(base.augmentation);
            this._afiSafi = CodeHelpers.emptyToNull(base.getAfiSafi());
        }
    
        @Override
        public Map<AfiSafiKey, AfiSafi> getAfiSafi() {
            return _afiSafi;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PerAfiSafiAdjRibInRoutes.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PerAfiSafiAdjRibInRoutes.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PerAfiSafiAdjRibInRoutes.bindingToString(this);
        }
    }
}
