package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Peers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.RouterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Routers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Status;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * list router {
 *   key router-id;
 *   leaf name {
 *     type string;
 *   }
 *   leaf description {
 *     type string;
 *   }
 *   leaf info {
 *     type string;
 *   }
 *   leaf router-id {
 *     type router-id;
 *   }
 *   leaf status {
 *     type status;
 *   }
 *   uses peers;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/routers/router</i>
 *
 * <p>To create instances of this class use {@link RouterBuilder}.
 * @see RouterBuilder
 * @see RouterKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Router
    extends
    ChildOf<Routers>,
    Augmentable<Router>,
    Peers,
    Identifiable<RouterKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("router");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.@NonNull Router obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDescription());
        result = prime * result + Objects.hashCode(obj.getInfo());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getPeer());
        result = prime * result + Objects.hashCode(obj.getRouterId());
        result = prime * result + Objects.hashCode(obj.getStatus());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.@NonNull Router thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInfo(), other.getInfo())) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPeer(), other.getPeer())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRouterId(), other.getRouterId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getStatus(), other.getStatus())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.@NonNull Router obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Router");
        CodeHelpers.appendValue(helper, "description", obj.getDescription());
        CodeHelpers.appendValue(helper, "info", obj.getInfo());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "peer", obj.getPeer());
        CodeHelpers.appendValue(helper, "routerId", obj.getRouterId());
        CodeHelpers.appendValue(helper, "status", obj.getStatus());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    @Override
    RouterKey key();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return description, or {@code null} if it is not present.
     *
     * @return {@code String} description, or {@code null} if it is not present.
     *
     */
    String getDescription();
    
    /**
     * Return description, guaranteed to be non-null.
     *
     * @return {@code String} description, guaranteed to be non-null.
     * @throws NoSuchElementException if description is not present
     *
     */
    default @NonNull String requireDescription() {
        return CodeHelpers.require(getDescription(), "description");
    }
    
    /**
     * Return info, or {@code null} if it is not present.
     *
     * @return {@code String} info, or {@code null} if it is not present.
     *
     */
    String getInfo();
    
    /**
     * Return info, guaranteed to be non-null.
     *
     * @return {@code String} info, guaranteed to be non-null.
     * @throws NoSuchElementException if info is not present
     *
     */
    default @NonNull String requireInfo() {
        return CodeHelpers.require(getInfo(), "info");
    }
    
    /**
     * Return routerId, or {@code null} if it is not present.
     *
     * @return {@code RouterId} routerId, or {@code null} if it is not present.
     *
     */
    RouterId getRouterId();
    
    /**
     * Return routerId, guaranteed to be non-null.
     *
     * @return {@code RouterId} routerId, guaranteed to be non-null.
     * @throws NoSuchElementException if routerId is not present
     *
     */
    default @NonNull RouterId requireRouterId() {
        return CodeHelpers.require(getRouterId(), "routerid");
    }
    
    /**
     * Return status, or {@code null} if it is not present.
     *
     * @return {@code Status} status, or {@code null} if it is not present.
     *
     */
    Status getStatus();
    
    /**
     * Return status, guaranteed to be non-null.
     *
     * @return {@code Status} status, guaranteed to be non-null.
     * @throws NoSuchElementException if status is not present
     *
     */
    default @NonNull Status requireStatus() {
        return CodeHelpers.require(getStatus(), "status");
    }

}

