package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Peers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.RouterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Status;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.PeerKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RouterBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RouterBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RouterBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RouterBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RouterBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class RouterBuilder implements Builder<Router> {

    private String _description;
    private String _info;
    private String _name;
    private Map<PeerKey, Peer> _peer;
    private RouterId _routerId;
    private Status _status;
    private RouterKey key;


    Map<Class<? extends Augmentation<Router>>, Augmentation<Router>> augmentation = Collections.emptyMap();

    public RouterBuilder() {
    }
    
    
    
    public RouterBuilder(Peers arg) {
        this._peer = arg.getPeer();
    }
    

    public RouterBuilder(Router base) {
        Map<Class<? extends Augmentation<Router>>, Augmentation<Router>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._routerId = base.getRouterId();
        this._description = base.getDescription();
        this._info = base.getInfo();
        this._name = base.getName();
        this._peer = base.getPeer();
        this._status = base.getStatus();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>Peers</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Peers) {
            this._peer = ((Peers)arg).getPeer();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Peers]");
    }

    public RouterKey key() {
        return key;
    }
    
    public String getDescription() {
        return _description;
    }
    
    public String getInfo() {
        return _info;
    }
    
    public String getName() {
        return _name;
    }
    
    public Map<PeerKey, Peer> getPeer() {
        return _peer;
    }
    
    public RouterId getRouterId() {
        return _routerId;
    }
    
    public Status getStatus() {
        return _status;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Router>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public RouterBuilder withKey(final RouterKey key) {
        this.key = key;
        return this;
    }
    
    public RouterBuilder setDescription(final String value) {
        this._description = value;
        return this;
    }
    
    public RouterBuilder setInfo(final String value) {
        this._info = value;
        return this;
    }
    
    public RouterBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    public RouterBuilder setPeer(final Map<PeerKey, Peer> values) {
        this._peer = values;
        return this;
    }
    
    public RouterBuilder setRouterId(final RouterId value) {
        this._routerId = value;
        return this;
    }
    
    public RouterBuilder setStatus(final Status value) {
        this._status = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public RouterBuilder addAugmentation(Augmentation<Router> augmentation) {
        Class<? extends Augmentation<Router>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public RouterBuilder removeAugmentation(Class<? extends Augmentation<Router>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Router build() {
        return new RouterImpl(this);
    }

    private static final class RouterImpl
        extends AbstractAugmentable<Router>
        implements Router {
    
        private final String _description;
        private final String _info;
        private final String _name;
        private final Map<PeerKey, Peer> _peer;
        private final RouterId _routerId;
        private final Status _status;
        private final RouterKey key;
    
        RouterImpl(RouterBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new RouterKey(base.getRouterId());
            }
            this._routerId = key.getRouterId();
            this._description = base.getDescription();
            this._info = base.getInfo();
            this._name = base.getName();
            this._peer = CodeHelpers.emptyToNull(base.getPeer());
            this._status = base.getStatus();
        }
    
        @Override
        public RouterKey key() {
            return key;
        }
        
        @Override
        public String getDescription() {
            return _description;
        }
        
        @Override
        public String getInfo() {
            return _info;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Map<PeerKey, Peer> getPeer() {
            return _peer;
        }
        
        @Override
        public RouterId getRouterId() {
            return _routerId;
        }
        
        @Override
        public Status getStatus() {
            return _status;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Router.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Router.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Router.bindingToString(this);
        }
    }
}
