/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.registry.BmpMessageRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BmpByteToMessageDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(BmpByteToMessageDecoder.class);
    private final BmpMessageRegistry registry;

    public BmpByteToMessageDecoder(BmpMessageRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws BmpDeserializationException {
        if (in.isReadable()) {
            LOG.trace("Received to decode: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
            out.add(this.registry.parseMessage(in));
        } else {
            LOG.trace("No more content in incoming buffer.");
        }
    }
}

