/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.protocol.bmp.api.BmpDispatcher;
import org.opendaylight.protocol.bmp.api.BmpSessionFactory;
import org.opendaylight.protocol.bmp.api.BmpSessionListenerFactory;
import org.opendaylight.protocol.bmp.impl.BmpDispatcherUtil;
import org.opendaylight.protocol.bmp.impl.BmpHandlerFactory;
import org.opendaylight.protocol.bmp.spi.registry.BmpMessageRegistry;
import org.opendaylight.protocol.concepts.KeyMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmpDispatcherImpl
implements BmpDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(BmpDispatcherImpl.class);
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int INITIAL_BACKOFF = 30000;
    private static final int MAXIMUM_BACKOFF = 720000;
    private static final long TIMEOUT = 10L;
    private final BmpHandlerFactory hf;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final BmpSessionFactory sessionFactory;
    private @GuardedBy(value={"this"}) boolean close;

    public BmpDispatcherImpl(EventLoopGroup bossGroup, EventLoopGroup workerGroup, BmpMessageRegistry registry, BmpSessionFactory sessionFactory) {
        if (Epoll.isAvailable()) {
            this.bossGroup = new EpollEventLoopGroup();
            this.workerGroup = new EpollEventLoopGroup();
        } else {
            this.bossGroup = Objects.requireNonNull(bossGroup);
            this.workerGroup = Objects.requireNonNull(workerGroup);
        }
        this.hf = new BmpHandlerFactory(Objects.requireNonNull(registry));
        this.sessionFactory = Objects.requireNonNull(sessionFactory);
    }

    public ChannelFuture createClient(InetSocketAddress remoteAddress, BmpSessionListenerFactory slf, KeyMapping keys) {
        Bootstrap bootstrap = BmpDispatcherUtil.createClientBootstrap(this.sessionFactory, this.hf, BmpDispatcherUtil::createChannelWithDecoder, slf, remoteAddress, this.workerGroup, 5000, keys);
        ChannelFuture channelPromise = bootstrap.connect();
        channelPromise.addListener((GenericFutureListener)new BootstrapListener(bootstrap, remoteAddress, slf, keys));
        LOG.debug("Initiated BMP Client {} at {}.", (Object)channelPromise, (Object)remoteAddress);
        return channelPromise;
    }

    public ChannelFuture createServer(InetSocketAddress address, BmpSessionListenerFactory slf, KeyMapping keys) {
        ServerBootstrap serverBootstrap = BmpDispatcherUtil.createServerBootstrap(this.sessionFactory, this.hf, slf, BmpDispatcherUtil::createChannelWithDecoder, this.bossGroup, this.workerGroup, keys);
        ChannelFuture channelFuture = serverBootstrap.bind((SocketAddress)address);
        LOG.debug("Initiated BMP server {} at {}.", (Object)channelFuture, (Object)address);
        return channelFuture;
    }

    public synchronized void close() {
        this.close = true;
        if (Epoll.isAvailable()) {
            this.workerGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
            this.bossGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        }
    }

    private class BootstrapListener
    implements ChannelFutureListener {
        private final Bootstrap bootstrap;
        private final InetSocketAddress remoteAddress;
        private final BmpSessionListenerFactory slf;
        private final KeyMapping keys;
        private long delay;
        private final Timer timer = new Timer();

        BootstrapListener(Bootstrap bootstrap, InetSocketAddress remoteAddress, BmpSessionListenerFactory slf, KeyMapping keys) {
            this.bootstrap = bootstrap;
            this.remoteAddress = remoteAddress;
            this.delay = 30000L;
            this.slf = slf;
            this.keys = keys;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isCancelled()) {
                LOG.debug("Connection {} cancelled!", (Object)future);
            } else if (future.isSuccess()) {
                LOG.debug("Connection {} succeeded!", (Object)future);
                future.channel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> this.scheduleConnect()));
            } else {
                if (this.delay > 720000L) {
                    LOG.warn("The time of maximum backoff has been exceeded. No further connection attempts with BMP router {}.", (Object)this.remoteAddress);
                    future.cancel(false);
                    return;
                }
                EventLoop loop = future.channel().eventLoop();
                loop.schedule(() -> this.bootstrap.connect().addListener((GenericFutureListener)this), this.delay, TimeUnit.MILLISECONDS);
                LOG.info("The connection try to BMP router {} failed. Next reconnection attempt in {} milliseconds.", (Object)this.remoteAddress, (Object)this.delay);
                this.delay *= 2L;
            }
        }

        private void scheduleConnect() {
            if (!BmpDispatcherImpl.this.close) {
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        BmpDispatcherImpl.this.createClient(BootstrapListener.this.remoteAddress, BootstrapListener.this.slf, BootstrapListener.this.keys);
                    }
                }, 5L);
            }
        }
    }
}

