/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.protocol.bmp.api.BmpSessionFactory;
import org.opendaylight.protocol.bmp.api.BmpSessionListenerFactory;
import org.opendaylight.protocol.bmp.impl.BmpHandlerFactory;
import org.opendaylight.protocol.concepts.KeyMapping;

public final class BmpDispatcherUtil {
    private static final int MAX_CONNECTIONS_COUNT = 128;

    private BmpDispatcherUtil() {
    }

    public static ChannelInitializer<AbstractChannel> createChannelWithDecoder(final @NonNull BmpSessionFactory sessionFactory, final @NonNull BmpHandlerFactory hf, final @NonNull BmpSessionListenerFactory slf) {
        return new ChannelInitializer<AbstractChannel>(){

            protected void initChannel(AbstractChannel ch) throws Exception {
                ch.pipeline().addLast(hf.getDecoders());
                ch.pipeline().addLast(new ChannelHandler[]{sessionFactory.getSession((Channel)ch, slf)});
            }
        };
    }

    public static ChannelInitializer<AbstractChannel> createChannelWithEncoder(final @NonNull BmpSessionFactory sessionFactory, final @NonNull BmpHandlerFactory hf, final @NonNull BmpSessionListenerFactory slf) {
        return new ChannelInitializer<AbstractChannel>(){

            protected void initChannel(AbstractChannel ch) throws Exception {
                ch.pipeline().addLast(hf.getEncoders());
                ch.pipeline().addLast(new ChannelHandler[]{sessionFactory.getSession((Channel)ch, slf)});
            }
        };
    }

    public static ServerBootstrap createServerBootstrap(@NonNull BmpSessionFactory sessionFactory, @NonNull BmpHandlerFactory hf, @NonNull BmpSessionListenerFactory slf, @NonNull CreateChannel createChannel, @NonNull EventLoopGroup bossGroup, @NonNull EventLoopGroup workerGroup, @NonNull KeyMapping keys) {
        return BmpDispatcherUtil.createServerBootstrap(sessionFactory, hf, slf, createChannel, bossGroup, workerGroup, keys, true);
    }

    public static ServerBootstrap createServerBootstrap(@NonNull BmpSessionFactory sessionFactory, @NonNull BmpHandlerFactory hf, @NonNull BmpSessionListenerFactory slf, @NonNull CreateChannel createChannel, @NonNull EventLoopGroup bossGroup, @NonNull EventLoopGroup workerGroup, @NonNull KeyMapping keys, boolean tryEpollSocket) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.childHandler(createChannel.create(sessionFactory, hf, slf));
        serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)128);
        serverBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        serverBootstrap.group(bossGroup, workerGroup);
        if (!tryEpollSocket) {
            serverBootstrap.channel(NioServerSocketChannel.class);
        } else {
            if (Epoll.isAvailable()) {
                serverBootstrap.channel(EpollServerSocketChannel.class);
            } else {
                serverBootstrap.channel(NioServerSocketChannel.class);
            }
            if (!keys.isEmpty()) {
                if (Epoll.isAvailable()) {
                    serverBootstrap.option(EpollChannelOption.TCP_MD5SIG, (Object)keys);
                } else {
                    throw new UnsupportedOperationException(Epoll.unavailabilityCause().getCause());
                }
            }
        }
        return serverBootstrap;
    }

    public static Bootstrap createClientBootstrap(@NonNull BmpSessionFactory sessionFactory, @NonNull BmpHandlerFactory hf, @NonNull CreateChannel createChannel, @NonNull BmpSessionListenerFactory slf, @NonNull InetSocketAddress remoteAddress, @NonNull EventLoopGroup workerGroup, int connectTimeout, @NonNull KeyMapping keys) {
        return BmpDispatcherUtil.createClientBootstrap(sessionFactory, hf, createChannel, slf, remoteAddress, null, workerGroup, connectTimeout, keys, false, true);
    }

    public static Bootstrap createClientBootstrap(@NonNull BmpSessionFactory sessionFactory, @NonNull BmpHandlerFactory hf, @NonNull CreateChannel createChannel, @NonNull BmpSessionListenerFactory slf, @NonNull InetSocketAddress remoteAddress, @Nullable SocketAddress localAddress, @NonNull EventLoopGroup workerGroup, int connectTimeout, @NonNull KeyMapping keys, boolean reuseAddress, boolean tryEpollSocket) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
        bootstrap.group(workerGroup);
        bootstrap.handler(createChannel.create(sessionFactory, hf, slf));
        if (localAddress != null) {
            bootstrap.localAddress(localAddress);
        }
        bootstrap.remoteAddress((SocketAddress)remoteAddress);
        if (!tryEpollSocket) {
            bootstrap.channel(NioSocketChannel.class);
        } else {
            if (Epoll.isAvailable()) {
                bootstrap.channel(EpollSocketChannel.class);
            } else {
                bootstrap.channel(NioSocketChannel.class);
            }
            if (!keys.isEmpty()) {
                if (Epoll.isAvailable()) {
                    bootstrap.option(EpollChannelOption.TCP_MD5SIG, (Object)keys);
                } else {
                    throw new UnsupportedOperationException(Epoll.unavailabilityCause().getCause());
                }
            }
        }
        return bootstrap;
    }

    @FunctionalInterface
    public static interface CreateChannel {
        public ChannelInitializer<AbstractChannel> create(@NonNull BmpSessionFactory var1, @NonNull BmpHandlerFactory var2, @NonNull BmpSessionListenerFactory var3);
    }
}

