/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandler;
import java.util.Objects;
import org.opendaylight.protocol.bmp.impl.BmpByteToMessageDecoder;
import org.opendaylight.protocol.bmp.impl.BmpMessageHeaderDecoder;
import org.opendaylight.protocol.bmp.impl.BmpMessageToByteEncoder;
import org.opendaylight.protocol.bmp.spi.registry.BmpMessageRegistry;

public final class BmpHandlerFactory {
    private final ChannelOutboundHandler encoder;
    private final BmpMessageRegistry registry;

    public BmpHandlerFactory(BmpMessageRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
        this.encoder = new BmpMessageToByteEncoder(registry);
    }

    public ChannelHandler[] getEncoders() {
        return new ChannelHandler[]{this.encoder};
    }

    public ChannelHandler[] getDecoders() {
        return new ChannelHandler[]{new BmpMessageHeaderDecoder(), new BmpByteToMessageDecoder(this.registry)};
    }
}

