/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Objects;
import org.opendaylight.protocol.bmp.spi.registry.BmpMessageRegistry;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class BmpMessageToByteEncoder
extends MessageToByteEncoder<Notification> {
    private static final Logger LOG = LoggerFactory.getLogger(BmpMessageToByteEncoder.class);
    private final BmpMessageRegistry registry;

    public BmpMessageToByteEncoder(BmpMessageRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    protected void encode(ChannelHandlerContext ctx, Notification message, ByteBuf out) throws Exception {
        LOG.trace("Encoding message: {}", (Object)message);
        this.registry.serializeMessage(message, out);
        LOG.debug("Message sent to output: {}", (Object)message);
    }
}

