/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl.app;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.google.common.util.concurrent.FluentFuture;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.opendaylight.protocol.bmp.api.BmpDispatcher;
import org.opendaylight.protocol.bmp.api.BmpSessionListenerFactory;
import org.opendaylight.protocol.bmp.impl.app.KeyConstructorUtil;
import org.opendaylight.protocol.bmp.impl.app.RouterSessionManager;
import org.opendaylight.protocol.bmp.impl.config.BmpDeployerDependencies;
import org.opendaylight.protocol.bmp.impl.spi.BmpMonitoringStation;
import org.opendaylight.protocol.concepts.KeyMapping;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.BmpMonitor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.Monitor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.rfc2385.cfg.rev160324.Rfc2385Key;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BmpMonitoringStationImpl
implements BmpMonitoringStation,
ClusterSingletonService {
    private static final Logger LOG = LoggerFactory.getLogger(BmpMonitoringStationImpl.class);
    private static final QName MONITOR_ID_QNAME = QName.create((QName)Monitor.QNAME, (String)"monitor-id").intern();
    private static final ServiceGroupIdentifier SERVICE_GROUP_IDENTIFIER = ServiceGroupIdentifier.create((String)"bmp-monitors-service-group");
    private final DOMDataBroker domDataBroker;
    private final InetSocketAddress address;
    private final MonitorId monitorId;
    private final Collection<MonitoredRouter> monitoredRouters;
    private final BmpDispatcher dispatcher;
    private final RouterSessionManager sessionManager;
    private final YangInstanceIdentifier yangMonitorId;
    private Channel channel;
    private ClusterSingletonServiceRegistration singletonServiceRegistration;

    public BmpMonitoringStationImpl(BmpDeployerDependencies bmpDeployerDependencies, BmpDispatcher dispatcher, MonitorId monitorId, InetSocketAddress address, Collection<MonitoredRouter> mrs) {
        this.domDataBroker = Objects.requireNonNull(bmpDeployerDependencies.getDomDataBroker());
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.monitorId = monitorId;
        this.monitoredRouters = mrs;
        this.address = Objects.requireNonNull(address);
        this.yangMonitorId = YangInstanceIdentifier.builder().node(BmpMonitor.QNAME).node(Monitor.QNAME).nodeWithKey(Monitor.QNAME, MONITOR_ID_QNAME, (Object)monitorId.getValue()).build();
        this.sessionManager = new RouterSessionManager(this.yangMonitorId, this.domDataBroker, bmpDeployerDependencies.getExtensions(), bmpDeployerDependencies.getTree());
        LOG.info("BMP Monitor Singleton Service {} registered, Monitor Id {}", (Object)this.getIdentifier().getName(), (Object)this.monitorId.getValue());
        this.singletonServiceRegistration = bmpDeployerDependencies.getClusterSingletonProvider().registerClusterSingletonService((ClusterSingletonService)this);
    }

    public synchronized void instantiateServiceInstance() {
        LOG.info("BMP Monitor Singleton Service {} instantiated, Monitor Id {}", (Object)this.getIdentifier().getName(), (Object)this.monitorId.getValue());
        ChannelFuture channelFuture = this.dispatcher.createServer(this.address, (BmpSessionListenerFactory)this.sessionManager, KeyConstructorUtil.constructKeys(this.monitoredRouters));
        try {
            this.channel = channelFuture.sync().channel();
            this.createEmptyMonitor();
            LOG.info("BMP Monitoring station {} started", (Object)this.monitorId.getValue());
            this.connectMonitoredRouters(this.dispatcher);
            LOG.info("Connecting to monitored routers completed.");
        }
        catch (InterruptedException e) {
            LOG.error("Failed to instantiate BMP Monitor Singleton {}", (Object)this.monitorId.getValue(), (Object)e);
        }
    }

    public synchronized FluentFuture<? extends CommitInfo> closeServiceInstance() {
        LOG.info("BMP Monitor Singleton Service {} instance closed, Monitor Id {}", (Object)this.getIdentifier().getName(), (Object)this.monitorId.getValue());
        if (this.channel != null) {
            this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                Preconditions.checkArgument((boolean)future.isSuccess(), (String)"Channel failed to close: %s", (Object)future.cause());
                this.sessionManager.close();
            }));
        }
        DOMDataTreeWriteTransaction wTx = this.domDataBroker.newWriteOnlyTransaction();
        wTx.delete(LogicalDatastoreType.OPERATIONAL, this.yangMonitorId);
        LOG.info("BMP monitoring station {} closed.", (Object)this.monitorId.getValue());
        return wTx.commit();
    }

    public ServiceGroupIdentifier getIdentifier() {
        return SERVICE_GROUP_IDENTIFIER;
    }

    private void connectMonitoredRouters(BmpDispatcher pdispatcher) {
        if (this.monitoredRouters != null) {
            for (MonitoredRouter mr : this.monitoredRouters) {
                if (!mr.isActive().booleanValue()) continue;
                Objects.requireNonNull(mr.getAddress());
                Objects.requireNonNull(mr.getPort());
                String s = mr.getAddress().getIpv4AddressNoZone().getValue();
                InetAddress addr = InetAddresses.forString((String)s);
                Rfc2385Key rfc2385KeyPassword = mr.getPassword();
                KeyMapping ret = KeyMapping.getKeyMapping((InetAddress)addr, (String)rfc2385KeyPassword.getValue());
                pdispatcher.createClient(Ipv4Util.toInetSocketAddress((IpAddressNoZone)mr.getAddress(), (PortNumber)mr.getPort()), (BmpSessionListenerFactory)this.sessionManager, ret);
            }
        }
    }

    private synchronized void createEmptyMonitor() {
        DOMDataTreeWriteTransaction wTx = this.domDataBroker.newWriteOnlyTransaction();
        wTx.put(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.builder().node(BmpMonitor.QNAME).node(Monitor.QNAME).nodeWithKey(Monitor.QNAME, MONITOR_ID_QNAME, (Object)this.monitorId.getValue()).build(), ImmutableNodes.mapEntryBuilder((QName)Monitor.QNAME, (QName)MONITOR_ID_QNAME, (Object)this.monitorId.getValue()).addChild((NormalizedNode)ImmutableNodes.leafNode((QName)MONITOR_ID_QNAME, (Object)this.monitorId.getValue())).addChild((NormalizedNode)((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)Router.QNAME).build())).build());
        try {
            wTx.commit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Failed to initiate BMP Monitor {}.", (Object)this.monitorId.getValue(), (Object)e);
        }
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.singletonServiceRegistration != null) {
            this.singletonServiceRegistration.close();
            this.singletonServiceRegistration = null;
        }
    }
}

