/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl.app;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.protocol.bgp.rib.spi.RIBExtensionConsumerContext;
import org.opendaylight.protocol.bgp.rib.spi.RIBSupport;
import org.opendaylight.protocol.bmp.impl.app.TableContext;
import org.opendaylight.protocol.bmp.impl.app.TablesUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev180329.ipv4.prefixes.DestinationIpv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev180329.ipv4.prefixes.destination.ipv4.Ipv4PrefixesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev180329.update.attributes.mp.reach.nlri.advertized.routes.destination.type.DestinationIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.UpdateMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.Attributes1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.Attributes2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.destination.DestinationType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpUnreachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpUnreachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.mp.reach.nlri.AdvertizedRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.mp.unreach.nlri.WithdrawnRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BmpRibInWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BmpRibInWriter.class);
    private static final LeafNode<Boolean> ATTRIBUTES_UPTODATE_FALSE = ImmutableNodes.leafNode((QName)QName.create((QName)TablesUtil.BMP_ATTRIBUTES_QNAME, (String)"uptodate"), (Object)Boolean.FALSE);
    private static final LeafNode<Boolean> ATTRIBUTES_UPTODATE_TRUE = ImmutableNodes.leafNode((QName)ATTRIBUTES_UPTODATE_FALSE.getNodeType(), (Object)Boolean.TRUE);
    private final DOMTransactionChain chain;
    private final Map<TablesKey, TableContext> tables;

    private BmpRibInWriter(YangInstanceIdentifier tablesRoot, DOMTransactionChain chain, RIBExtensionConsumerContext ribExtensions, Set<TablesKey> tableTypes, BindingCodecTree tree) {
        this.chain = chain;
        DOMDataTreeWriteTransaction tx = this.chain.newWriteOnlyTransaction();
        this.tables = BmpRibInWriter.createTableInstance(tableTypes, tablesRoot, tx, ribExtensions, tree).build();
        LOG.debug("New RIB table {} structure installed.", (Object)tablesRoot.toString());
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Successful commit");
            }

            public void onFailure(Throwable trw) {
                LOG.error("Failed commit", trw);
            }
        }, MoreExecutors.directExecutor());
    }

    public static BmpRibInWriter create(@NonNull YangInstanceIdentifier tablesRootPath, @NonNull DOMTransactionChain chain, @NonNull RIBExtensionConsumerContext extensions, @NonNull Set<TablesKey> tableTypes, @NonNull BindingCodecTree tree) {
        return new BmpRibInWriter(tablesRootPath, chain, extensions, tableTypes, tree);
    }

    public void onMessage(UpdateMessage message) {
        if (!this.checkEndOfRib(message)) {
            Attributes attrs = message.getAttributes();
            MpReachNlri mpReach = null;
            if (message.getNlri() != null) {
                mpReach = BmpRibInWriter.prefixesToMpReach(message);
            } else if (attrs != null && attrs.augmentation(Attributes1.class) != null) {
                mpReach = ((Attributes1)attrs.augmentation(Attributes1.class)).getMpReachNlri();
            }
            if (mpReach != null) {
                this.addRoutes(mpReach, attrs);
                return;
            }
            MpUnreachNlri mpUnreach = null;
            if (message.getWithdrawnRoutes() != null) {
                mpUnreach = BmpRibInWriter.prefixesToMpUnreach(message);
            } else if (attrs != null && attrs.augmentation(Attributes2.class) != null) {
                mpUnreach = ((Attributes2)attrs.augmentation(Attributes2.class)).getMpUnreachNlri();
            }
            if (mpUnreach != null) {
                this.removeRoutes(mpUnreach);
            }
        }
    }

    private static ImmutableMap.Builder<TablesKey, TableContext> createTableInstance(Set<TablesKey> tableTypes, YangInstanceIdentifier yangTableRootIId, DOMDataTreeWriteTransaction tx, RIBExtensionConsumerContext ribExtensions, BindingCodecTree tree) {
        ImmutableMap.Builder tb = ImmutableMap.builder();
        for (TablesKey k : tableTypes) {
            RIBSupport rs = ribExtensions.getRIBSupport(k);
            if (rs == null) {
                LOG.warn("No support for table type {}, skipping it", (Object)k);
                continue;
            }
            TableContext ctx = new TableContext(rs, yangTableRootIId.node((YangInstanceIdentifier.PathArgument)TablesUtil.toYangTablesKey(k)).toOptimized(), tree);
            ctx.createTable(tx);
            tx.put(LogicalDatastoreType.OPERATIONAL, ctx.getTableId().node(TablesUtil.BMP_ATTRIBUTES_QNAME).node(ATTRIBUTES_UPTODATE_FALSE.getNodeType()), ATTRIBUTES_UPTODATE_FALSE);
            LOG.debug("Created table instance {}", (Object)ctx.getTableId());
            tb.put((Object)k, (Object)ctx);
        }
        return tb;
    }

    private synchronized void addRoutes(MpReachNlri nlri, Attributes attributes) {
        TablesKey key = new TablesKey(nlri.getAfi(), nlri.getSafi());
        TableContext ctx = this.tables.get(key);
        if (ctx == null) {
            LOG.debug("No table for {}, not accepting NLRI {}", (Object)key, (Object)nlri);
            return;
        }
        DOMDataTreeWriteTransaction tx = this.chain.newWriteOnlyTransaction();
        ctx.writeRoutes(tx, nlri, attributes);
        LOG.trace("Write routes {}", (Object)nlri);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Successful commit");
            }

            public void onFailure(Throwable trw) {
                LOG.error("Failed commit", trw);
            }
        }, MoreExecutors.directExecutor());
    }

    private static MpReachNlri prefixesToMpReach(UpdateMessage message) {
        List prefixes = message.getNlri().stream().map(n -> new Ipv4PrefixesBuilder().setPrefix(n.getPrefix()).setPathId(n.getPathId()).build()).collect(Collectors.toList());
        MpReachNlriBuilder b = new MpReachNlriBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setAdvertizedRoutes(new AdvertizedRoutesBuilder().setDestinationType((DestinationType)new DestinationIpv4CaseBuilder().setDestinationIpv4(new DestinationIpv4Builder().setIpv4Prefixes(prefixes).build()).build()).build());
        if (message.getAttributes() != null) {
            b.setCNextHop(message.getAttributes().getCNextHop());
        }
        return b.build();
    }

    private synchronized void removeRoutes(MpUnreachNlri nlri) {
        TablesKey key = new TablesKey(nlri.getAfi(), nlri.getSafi());
        TableContext ctx = this.tables.get(key);
        if (ctx == null) {
            LOG.debug("No table for {}, not accepting NLRI {}", (Object)key, (Object)nlri);
            return;
        }
        LOG.trace("Removing routes {}", (Object)nlri);
        DOMDataTreeWriteTransaction tx = this.chain.newWriteOnlyTransaction();
        ctx.removeRoutes(tx, nlri);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Successful commit");
            }

            public void onFailure(Throwable trw) {
                LOG.error("Failed commit", trw);
            }
        }, MoreExecutors.directExecutor());
    }

    private static MpUnreachNlri prefixesToMpUnreach(UpdateMessage message) {
        ArrayList prefixes = new ArrayList();
        message.getWithdrawnRoutes().forEach(w -> prefixes.add(new Ipv4PrefixesBuilder().setPrefix(w.getPrefix()).setPathId(w.getPathId()).build()));
        return new MpUnreachNlriBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setWithdrawnRoutes(new WithdrawnRoutesBuilder().setDestinationType((DestinationType)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev180329.update.attributes.mp.unreach.nlri.withdrawn.routes.destination.type.DestinationIpv4CaseBuilder().setDestinationIpv4(new DestinationIpv4Builder().setIpv4Prefixes(prefixes).build()).build()).build()).build();
    }

    private boolean checkEndOfRib(UpdateMessage msg) {
        TablesKey type = new TablesKey(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class);
        boolean isEOR = false;
        if (msg.getNlri() == null && msg.getWithdrawnRoutes() == null) {
            if (msg.getAttributes() != null) {
                if (msg.getAttributes().augmentation(Attributes1.class) != null) {
                    Attributes1 pa = (Attributes1)msg.getAttributes().augmentation(Attributes1.class);
                    if (pa.getMpReachNlri() != null) {
                        type = new TablesKey(pa.getMpReachNlri().getAfi(), pa.getMpReachNlri().getSafi());
                    }
                } else if (msg.getAttributes().augmentation(Attributes2.class) != null) {
                    Attributes2 pa = (Attributes2)msg.getAttributes().augmentation(Attributes2.class);
                    if (pa.getMpUnreachNlri() != null) {
                        type = new TablesKey(pa.getMpUnreachNlri().getAfi(), pa.getMpUnreachNlri().getSafi());
                    }
                    if (pa.getMpUnreachNlri().getWithdrawnRoutes() == null) {
                        isEOR = true;
                    }
                }
            } else {
                isEOR = true;
            }
        }
        if (isEOR) {
            this.markTableUptodated(type);
            LOG.debug("BMP Synchronization finished for table {} ", (Object)type);
        }
        return isEOR;
    }

    private synchronized void markTableUptodated(TablesKey tableTypes) {
        DOMDataTreeWriteTransaction tx = this.chain.newWriteOnlyTransaction();
        TableContext ctxPre = this.tables.get(tableTypes);
        tx.merge(LogicalDatastoreType.OPERATIONAL, ctxPre.getTableId().node(TablesUtil.BMP_ATTRIBUTES_QNAME).node(ATTRIBUTES_UPTODATE_TRUE.getNodeType()), ATTRIBUTES_UPTODATE_TRUE);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Successful commit");
            }

            public void onFailure(Throwable trw) {
                LOG.error("Failed commit", trw);
            }
        }, MoreExecutors.directExecutor());
    }
}

