/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl.app;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.protocol.bgp.rib.spi.RIBExtensionConsumerContext;
import org.opendaylight.protocol.bmp.api.BmpSession;
import org.opendaylight.protocol.bmp.impl.app.BmpRouterPeerImpl;
import org.opendaylight.protocol.bmp.impl.app.RouterSessionManager;
import org.opendaylight.protocol.bmp.impl.spi.BmpRouter;
import org.opendaylight.protocol.bmp.impl.spi.BmpRouterPeer;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDownNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.informations.StringInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.RouterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BmpRouterImpl
implements BmpRouter,
DOMTransactionChainListener {
    private static final Logger LOG = LoggerFactory.getLogger(BmpRouterImpl.class);
    private static final QName ROUTER_ID_QNAME = QName.create((QName)Router.QNAME, (String)"router-id").intern();
    private static final QName ROUTER_STATUS_QNAME = QName.create((QName)Router.QNAME, (String)"status").intern();
    private static final QName ROUTER_NAME_QNAME = QName.create((QName)Router.QNAME, (String)"name").intern();
    private static final QName ROUTER_DESCRIPTION_QNAME = QName.create((QName)Router.QNAME, (String)"description").intern();
    private static final QName ROUTER_INFO_QNAME = QName.create((QName)Router.QNAME, (String)"info").intern();
    private static final String UP = "up";
    private static final String DOWN = "down";
    private final RouterSessionManager sessionManager;
    private final @GuardedBy(value={"this"}) Map<PeerId, BmpRouterPeer> peers = new HashMap<PeerId, BmpRouterPeer>();
    private final DOMTransactionChain domTxChain;
    private final DOMDataBroker domDataBroker;
    private final RIBExtensionConsumerContext extensions;
    private final BindingCodecTree tree;
    private BmpSession session;
    private RouterId routerId;
    private String routerIp;
    private @GuardedBy(value={"this"}) YangInstanceIdentifier routerYangIId;
    private @GuardedBy(value={"this"}) YangInstanceIdentifier peersYangIId;

    public BmpRouterImpl(RouterSessionManager sessionManager) {
        this.sessionManager = Objects.requireNonNull(sessionManager);
        this.domDataBroker = sessionManager.getDomDataBroker();
        this.domTxChain = this.domDataBroker.createMergingTransactionChain((DOMTransactionChainListener)this);
        this.extensions = sessionManager.getExtensions();
        this.tree = sessionManager.getCodecTree();
    }

    public synchronized void onSessionUp(BmpSession psession) {
        this.session = psession;
        this.routerIp = InetAddresses.toAddrString((InetAddress)this.session.getRemoteAddress());
        this.routerId = new RouterId(Ipv4Util.getIpAddress((InetAddress)this.session.getRemoteAddress()));
        if (!this.sessionManager.addSessionListener(this)) {
            LOG.warn("Redundant BMP session with remote router {} ({}) detected. This BMP session will be abandoned.", (Object)this.routerIp, (Object)this.session);
            this.close();
        } else {
            this.routerYangIId = YangInstanceIdentifier.builder((YangInstanceIdentifier)this.sessionManager.getRoutersYangIId()).nodeWithKey(Router.QNAME, ROUTER_ID_QNAME, (Object)this.routerIp).build();
            this.peersYangIId = YangInstanceIdentifier.builder((YangInstanceIdentifier)this.routerYangIId).node(Peer.QNAME).build();
            this.createRouterEntry();
            LOG.info("BMP session with remote router {} ({}) is up now.", (Object)this.routerIp, (Object)this.session);
        }
    }

    public synchronized void onSessionDown(Exception exception) {
        this.tearDown();
    }

    public void onMessage(Notification message) {
        if (message instanceof InitiationMessage) {
            this.onInitiate((InitiationMessage)message);
        } else if (message instanceof PeerUpNotification) {
            this.onPeerUp((PeerUpNotification)message);
        } else if (message instanceof PeerHeader) {
            this.delegateToPeer(message);
        }
    }

    @Override
    public synchronized RouterId getRouterId() {
        return this.routerId;
    }

    @Override
    public synchronized void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exc) {
                LOG.error("Fail to close session.", (Throwable)exc);
            }
        }
    }

    @Holding(value={"this"})
    private synchronized void tearDown() {
        if (this.session == null) {
            return;
        }
        LOG.info("BMP Session with remote router {} ({}) went down.", (Object)this.routerIp, (Object)this.session);
        this.session = null;
        Iterator<BmpRouterPeer> it = this.peers.values().iterator();
        try {
            while (it.hasNext()) {
                it.next().close();
                it.remove();
            }
            this.domTxChain.close();
        }
        catch (Exception e) {
            LOG.error("Failed to properly close BMP application.", (Throwable)e);
        }
        finally {
            if (this.isDatastoreWritable()) {
                try {
                    DOMDataTreeWriteTransaction wTx = this.domDataBroker.newWriteOnlyTransaction();
                    wTx.delete(LogicalDatastoreType.OPERATIONAL, this.routerYangIId);
                    wTx.commit().get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Failed to remove BMP router data from DS.", (Throwable)e);
                }
                this.sessionManager.removeSessionListener(this);
            }
        }
    }

    public synchronized void onTransactionChainFailed(DOMTransactionChain chain, DOMDataTreeTransaction transaction, Throwable cause) {
        LOG.error("Transaction chain failed.", cause);
    }

    public void onTransactionChainSuccessful(DOMTransactionChain chain) {
        LOG.debug("Transaction chain {} successfully.", (Object)chain);
    }

    private synchronized boolean isDatastoreWritable() {
        return this.routerYangIId != null;
    }

    private synchronized void createRouterEntry() {
        Preconditions.checkState((boolean)this.isDatastoreWritable());
        DOMDataTreeWriteTransaction wTx = this.domTxChain.newWriteOnlyTransaction();
        wTx.put(LogicalDatastoreType.OPERATIONAL, this.routerYangIId, Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)Router.QNAME, (QName)ROUTER_ID_QNAME, (Object)this.routerIp)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)ROUTER_ID_QNAME, (Object)this.routerIp)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)ROUTER_STATUS_QNAME, (Object)DOWN)).withChild((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)Peer.QNAME).build()).build());
        wTx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Successful commit");
            }

            public void onFailure(Throwable trw) {
                LOG.error("Failed commit", trw);
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized void onInitiate(InitiationMessage initiation) {
        Preconditions.checkState((boolean)this.isDatastoreWritable());
        DOMDataTreeWriteTransaction wTx = this.domTxChain.newWriteOnlyTransaction();
        wTx.merge(LogicalDatastoreType.OPERATIONAL, this.routerYangIId, Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)Router.QNAME, (QName)ROUTER_ID_QNAME, (Object)this.routerIp)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)ROUTER_NAME_QNAME, (Object)initiation.getTlvs().getNameTlv().getName())).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)ROUTER_DESCRIPTION_QNAME, (Object)initiation.getTlvs().getDescriptionTlv().getDescription())).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)ROUTER_INFO_QNAME, (Object)BmpRouterImpl.getStringInfo(initiation.getTlvs().getStringInformation()))).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)ROUTER_STATUS_QNAME, (Object)UP)).build());
        wTx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Successful commit");
            }

            public void onFailure(Throwable trw) {
                LOG.error("Failed commit", trw);
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized void onPeerUp(PeerUpNotification peerUp) {
        PeerId peerId = BmpRouterImpl.getPeerIdFromOpen((OpenMessage)peerUp.getReceivedOpen());
        if (!this.getPeer(peerId).isPresent()) {
            BmpRouterPeer peer = BmpRouterPeerImpl.createRouterPeer(this.domTxChain, this.peersYangIId, peerUp, this.extensions, this.tree, peerId);
            this.peers.put(peerId, peer);
            LOG.debug("Router {}: Peer {} goes up.", (Object)this.routerIp, (Object)peerId.getValue());
        } else {
            LOG.debug("Peer: {} for Router: {} already exists.", (Object)peerId.getValue(), (Object)this.routerIp);
        }
    }

    private synchronized void delegateToPeer(Notification perPeerMessage) {
        PeerId peerId = BmpRouterImpl.getPeerId((PeerHeader)perPeerMessage);
        Optional<BmpRouterPeer> maybePeer = this.getPeer(peerId);
        if (maybePeer.isPresent()) {
            maybePeer.get().onPeerMessage(perPeerMessage);
            if (perPeerMessage instanceof PeerDownNotification) {
                this.peers.remove(peerId);
                LOG.debug("Router {}: Peer {} removed.", (Object)this.routerIp, (Object)peerId.getValue());
            }
        } else {
            LOG.debug("Peer: {} for Router: {} was not found.", (Object)peerId.getValue(), (Object)this.routerIp);
        }
    }

    private Optional<BmpRouterPeer> getPeer(PeerId peerId) {
        return Optional.ofNullable(this.peers.get(peerId));
    }

    private static PeerId getPeerId(PeerHeader peerHeader) {
        return new PeerId(peerHeader.getPeerHeader().getBgpId().getValue());
    }

    private static PeerId getPeerIdFromOpen(OpenMessage open) {
        return new PeerId(open.getBgpIdentifier().getValue());
    }

    private static String getStringInfo(List<StringInformation> info) {
        StringBuilder builder = new StringBuilder();
        if (info != null) {
            for (StringInformation string : info) {
                if (string.getStringTlv() == null) continue;
                builder.append(string.getStringTlv().getStringInfo());
                builder.append(";");
            }
        }
        return builder.toString();
    }
}

