/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl.app;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.protocol.bgp.rib.spi.RIBExtensionConsumerContext;
import org.opendaylight.protocol.bmp.impl.app.BmpRibInWriter;
import org.opendaylight.protocol.bmp.impl.app.TablesUtil;
import org.opendaylight.protocol.bmp.impl.spi.BmpRouterPeer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.UpdateMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.OptionalCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.AdjRibInType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Mirror;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.MirrorInformationCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDownNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMirroringMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Stat;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatsReportsMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.ReceivedOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.BmpMonitor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.Monitor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PeerSession;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PostPolicyRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PrePolicyRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BmpRouterPeerImpl
implements BmpRouterPeer {
    private static final Logger LOG = LoggerFactory.getLogger(BmpRouterPeerImpl.class);
    private static final String TIMESTAMP_SEC = "timestamp-sec";
    private static final QName PEER_ID_QNAME = QName.create((QName)Peer.QNAME, (String)"peer-id").intern();
    private static final QName PEER_TYPE_QNAME = QName.create((QName)Peer.QNAME, (String)"type");
    private static final QName PEER_ADDRESS_QNAME = QName.create((QName)Peer.QNAME, (String)"address").intern();
    private static final QName PEER_AS_QNAME = QName.create((QName)Peer.QNAME, (String)"as").intern();
    private static final QName PEER_BGP_ID_QNAME = QName.create((QName)Peer.QNAME, (String)"bgp-id").intern();
    private static final QName PEER_DISTINGUISHER_QNAME = QName.create((QName)Peer.QNAME, (String)"router-distinguisher").intern();
    private static final QName PEER_LOCAL_ADDRESS_QNAME = QName.create((QName)PeerSession.QNAME, (String)"local-address").intern();
    private static final QName PEER_LOCAL_PORT_QNAME = QName.create((QName)PeerSession.QNAME, (String)"local-port").intern();
    private static final QName PEER_REMOTE_PORT_QNAME = QName.create((QName)PeerSession.QNAME, (String)"remote-port").intern();
    private static final QName PEER_STATUS_QNAME = QName.create((QName)PeerSession.QNAME, (String)"status").intern();
    private static final QName PEER_UP_TIMESTAMP_QNAME = QName.create((QName)PeerSession.QNAME, (String)"timestamp-sec").intern();
    private static final QName PEER_STATS_TIMESTAMP_QNAME = QName.create((QName)Stats.QNAME, (String)"timestamp-sec").intern();
    private static final QName PEER_MIRROR_INFORMATION_QNAME = QName.create((QName)Mirrors.QNAME, (String)"information").intern();
    private static final QName PEER_MIRROR_TIMESTAMP_QNAME = QName.create((QName)Mirrors.QNAME, (String)"timestamp-sec").intern();
    private static final QName STAT0_QNAME = QName.create((QName)Stats.QNAME, (String)"rejected-prefixes").intern();
    private static final QName STAT1_QNAME = QName.create((QName)Stats.QNAME, (String)"duplicate-prefix-advertisements").intern();
    private static final QName STAT2_QNAME = QName.create((QName)Stats.QNAME, (String)"duplicate-withdraws").intern();
    private static final QName STAT3_QNAME = QName.create((QName)Stats.QNAME, (String)"invalidated-cluster-list-loop").intern();
    private static final QName STAT4_QNAME = QName.create((QName)Stats.QNAME, (String)"invalidated-as-path-loop").intern();
    private static final QName STAT5_QNAME = QName.create((QName)Stats.QNAME, (String)"invalidated-originator-id").intern();
    private static final QName STAT6_QNAME = QName.create((QName)Stats.QNAME, (String)"invalidated-as-confed-loop").intern();
    private static final QName STAT7_QNAME = QName.create((QName)Stats.QNAME, (String)"adj-ribs-in-routes");
    private static final QName STAT8_QNAME = QName.create((QName)Stats.QNAME, (String)"loc-rib-routes");
    private static final QName STAT9_QNAME = QName.create((QName)Stats.QNAME, (String)"per-afi-safi-adj-rib-in-routes").intern();
    private static final QName AF_QNAME = QName.create((QName)Stats.QNAME, (String)"afi-safi").intern();
    private static final QName COUNT_QNAME = QName.create((QName)Stats.QNAME, (String)"count").intern();
    private static final QName STAT10_QNAME = QName.create((QName)Stats.QNAME, (String)"per-afi-safi-loc-rib-routes").intern();
    private static final QName STAT11_QNAME = QName.create((QName)Stats.QNAME, (String)"updates-treated-as-withdraw").intern();
    private static final QName STAT13_QNAME = QName.create((QName)Stats.QNAME, (String)"duplicate-updates").intern();
    private static final TablesKey DEFAULT_TABLE = new TablesKey(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class);
    private static final InstanceIdentifier<PeerSession> PEER_SESSION_ID = InstanceIdentifier.builder(BmpMonitor.class).child(Monitor.class).child(Router.class).child(Peer.class).child(PeerSession.class).build();
    private static final InstanceIdentifier<SentOpen> SENT_OPEN_IID = PEER_SESSION_ID.child(SentOpen.class);
    private static final InstanceIdentifier<ReceivedOpen> RECEIVED_OPEN_IID = PEER_SESSION_ID.child(ReceivedOpen.class);
    private final DOMTransactionChain domTxChain;
    private final PeerId peerId;
    private final YangInstanceIdentifier peerYangIId;
    private final BmpRibInWriter prePolicyWriter;
    private final BmpRibInWriter postPolicyWriter;
    private final BindingDataObjectCodecTreeNode<SentOpen> sentOpenCodec;
    private final BindingDataObjectCodecTreeNode<ReceivedOpen> receivedOpenCodec;
    private boolean up = true;

    private BmpRouterPeerImpl(DOMTransactionChain domTxChain, YangInstanceIdentifier peersYangIId, PeerId peerId, RIBExtensionConsumerContext extensions, PeerUpNotification peerUp, BindingCodecTree tree) {
        this.domTxChain = Objects.requireNonNull(domTxChain);
        this.peerId = peerId;
        this.peerYangIId = YangInstanceIdentifier.builder((YangInstanceIdentifier)peersYangIId).nodeWithKey(Peer.QNAME, PEER_ID_QNAME, (Object)this.peerId.getValue()).build();
        this.sentOpenCodec = tree.getSubtreeCodec(SENT_OPEN_IID);
        this.receivedOpenCodec = tree.getSubtreeCodec(RECEIVED_OPEN_IID);
        Set<TablesKey> peerTables = BmpRouterPeerImpl.setPeerTables(peerUp.getReceivedOpen());
        DOMDataTreeWriteTransaction wTx = this.domTxChain.newWriteOnlyTransaction();
        wTx.put(LogicalDatastoreType.OPERATIONAL, this.peerYangIId, (NormalizedNode)this.createPeerEntry(peerUp));
        wTx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Successful commit");
            }

            public void onFailure(Throwable trw) {
                LOG.error("Failed commit", trw);
            }
        }, MoreExecutors.directExecutor());
        this.prePolicyWriter = BmpRibInWriter.create(this.peerYangIId.node(PrePolicyRib.QNAME).node(TablesUtil.BMP_TABLES_QNAME), this.domTxChain, extensions, peerTables, tree);
        this.postPolicyWriter = BmpRibInWriter.create(this.peerYangIId.node(PostPolicyRib.QNAME).node(TablesUtil.BMP_TABLES_QNAME), this.domTxChain, extensions, peerTables, tree);
    }

    static BmpRouterPeer createRouterPeer(DOMTransactionChain domTxChain, YangInstanceIdentifier peersYangIId, PeerUpNotification peerUp, RIBExtensionConsumerContext extensions, BindingCodecTree tree, PeerId peerId) {
        return new BmpRouterPeerImpl(domTxChain, peersYangIId, peerId, extensions, peerUp, tree);
    }

    @Override
    public void onPeerMessage(Notification message) {
        if (message instanceof PeerDownNotification) {
            this.onPeerDown();
        } else if (message instanceof RouteMonitoringMessage) {
            this.onRouteMonitoring((RouteMonitoringMessage)message);
        } else if (message instanceof StatsReportsMessage) {
            this.onStatsReports((StatsReportsMessage)message);
        } else if (message instanceof RouteMirroringMessage) {
            this.onRouteMirror((RouteMirroringMessage)message);
        }
    }

    private void onRouteMonitoring(RouteMonitoringMessage routeMonitoring) {
        if (this.up) {
            AdjRibInType ribType = routeMonitoring.getPeerHeader().getAdjRibInType();
            switch (ribType) {
                case PrePolicy: {
                    this.prePolicyWriter.onMessage((UpdateMessage)routeMonitoring.getUpdate());
                    break;
                }
                case PostPolicy: {
                    this.postPolicyWriter.onMessage((UpdateMessage)routeMonitoring.getUpdate());
                    break;
                }
            }
        }
    }

    private synchronized void onStatsReports(StatsReportsMessage statsReports) {
        if (this.up) {
            DOMDataTreeWriteTransaction wTx = this.domTxChain.newWriteOnlyTransaction();
            wTx.merge(LogicalDatastoreType.OPERATIONAL, this.peerYangIId.node(Stats.QNAME), (NormalizedNode)BmpRouterPeerImpl.createStats((Stat)statsReports, statsReports.getPeerHeader().getTimestampSec()));
            wTx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

                public void onSuccess(CommitInfo result) {
                    LOG.trace("Successful commit");
                }

                public void onFailure(Throwable trw) {
                    LOG.error("Failed commit", trw);
                }
            }, MoreExecutors.directExecutor());
        }
    }

    private synchronized void onRouteMirror(RouteMirroringMessage mirror) {
        DOMDataTreeWriteTransaction wTx = this.domTxChain.newWriteOnlyTransaction();
        wTx.merge(LogicalDatastoreType.OPERATIONAL, this.peerYangIId.node(Mirrors.QNAME), (NormalizedNode)BmpRouterPeerImpl.createMirrors((Mirror)mirror, mirror.getPeerHeader().getTimestampSec()));
        wTx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Successful commit");
            }

            public void onFailure(Throwable trw) {
                LOG.error("Failed commit", trw);
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized void onPeerDown() {
        DOMDataTreeWriteTransaction wTx = this.domTxChain.newWriteOnlyTransaction();
        wTx.delete(LogicalDatastoreType.OPERATIONAL, this.peerYangIId);
        wTx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Successful commit");
            }

            public void onFailure(Throwable trw) {
                LOG.error("Failed commit", trw);
            }
        }, MoreExecutors.directExecutor());
        this.close();
    }

    @Override
    public void close() {
        Preconditions.checkState((boolean)this.up, (Object)"Already closed.");
        this.up = false;
    }

    private static Set<TablesKey> setPeerTables(ReceivedOpen open) {
        HashSet tables = Sets.newHashSet((Object[])new TablesKey[]{DEFAULT_TABLE});
        for (BgpParameters param : open.nonnullBgpParameters()) {
            for (OptionalCapabilities optCapa : param.nonnullOptionalCapabilities()) {
                MultiprotocolCapability multi;
                CParameters1 augment;
                CParameters cParam = optCapa.getCParameters();
                if (cParam == null || (augment = (CParameters1)cParam.augmentation(CParameters1.class)) == null || (multi = augment.getMultiprotocolCapability()) == null) continue;
                tables.add(new TablesKey(multi.getAfi(), multi.getSafi()));
            }
        }
        return tables;
    }

    private ContainerNode createPeerSessionUp(PeerUp peerUp, Timestamp timestamp) {
        DataContainerNodeBuilder builder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(PeerSession.QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_LOCAL_ADDRESS_QNAME, (Object)BmpRouterPeerImpl.getStringIpAddress(peerUp.getLocalAddress()))).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_LOCAL_PORT_QNAME, (Object)peerUp.getLocalPort().getValue())).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_REMOTE_PORT_QNAME, (Object)peerUp.getRemotePort().getValue())).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_STATUS_QNAME, (Object)"up")).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_UP_TIMESTAMP_QNAME, (Object)timestamp.getValue()));
        if (this.receivedOpenCodec != null) {
            builder.withChild((DataContainerChild)((ContainerNode)this.receivedOpenCodec.serialize((BindingObject)peerUp.getReceivedOpen())));
        }
        if (this.sentOpenCodec != null) {
            builder.withChild((DataContainerChild)((ContainerNode)this.sentOpenCodec.serialize((BindingObject)peerUp.getSentOpen())));
        }
        return (ContainerNode)builder.build();
    }

    private MapEntryNode createPeerEntry(PeerUpNotification peerUp) {
        PeerHeader peerHeader = peerUp.getPeerHeader();
        DataContainerNodeBuilder mapEntryBuilder = Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)Peer.QNAME, (QName)PEER_ID_QNAME, (Object)this.peerId.getValue())).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_ID_QNAME, (Object)this.peerId.getValue())).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_TYPE_QNAME, (Object)peerHeader.getType().name().toLowerCase(Locale.ENGLISH))).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_ADDRESS_QNAME, (Object)BmpRouterPeerImpl.getStringIpAddress(peerHeader.getAddress()))).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_AS_QNAME, (Object)peerHeader.getAs().getValue())).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_BGP_ID_QNAME, (Object)peerHeader.getBgpId().getValue())).withChild((DataContainerChild)this.createPeerSessionUp((PeerUp)peerUp, peerHeader.getTimestampSec())).withChild((DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(PrePolicyRib.QNAME)).withChild((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)TablesUtil.BMP_TABLES_QNAME).build()).build()).withChild((DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(PostPolicyRib.QNAME)).withChild((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)TablesUtil.BMP_TABLES_QNAME).build()).build());
        Peer.PeerDistinguisher pd = peerHeader.getPeerDistinguisher();
        if (pd != null) {
            mapEntryBuilder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_DISTINGUISHER_QNAME, (Object)pd.getRouteDistinguisher()));
        }
        return (MapEntryNode)mapEntryBuilder.build();
    }

    private static ContainerNode createStats(Stat stat, Timestamp timestamp) {
        DataContainerNodeBuilder builder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Stats.QNAME));
        builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_STATS_TIMESTAMP_QNAME, (Object)timestamp.getValue()));
        Tlvs tlvs = stat.getTlvs();
        if (tlvs != null) {
            BmpRouterPeerImpl.statsForTlvs(tlvs, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode>)builder);
        }
        return (ContainerNode)builder.build();
    }

    private static void statsForTlvs(Tlvs tlvs, DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> builder) {
        if (tlvs.getRejectedPrefixesTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT0_QNAME, (Object)tlvs.getRejectedPrefixesTlv().getCount().getValue()));
        }
        if (tlvs.getDuplicatePrefixAdvertisementsTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT1_QNAME, (Object)tlvs.getDuplicatePrefixAdvertisementsTlv().getCount().getValue()));
        }
        if (tlvs.getDuplicateWithdrawsTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT2_QNAME, (Object)tlvs.getDuplicateWithdrawsTlv().getCount().getValue()));
        }
        if (tlvs.getInvalidatedClusterListLoopTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT3_QNAME, (Object)tlvs.getInvalidatedClusterListLoopTlv().getCount().getValue()));
        }
        if (tlvs.getInvalidatedAsPathLoopTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT4_QNAME, (Object)tlvs.getInvalidatedAsPathLoopTlv().getCount().getValue()));
        }
        if (tlvs.getInvalidatedOriginatorIdTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT5_QNAME, (Object)tlvs.getInvalidatedOriginatorIdTlv().getCount().getValue()));
        }
        if (tlvs.getInvalidatedAsConfedLoopTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT6_QNAME, (Object)tlvs.getInvalidatedAsConfedLoopTlv().getCount().getValue()));
        }
        if (tlvs.getAdjRibsInRoutesTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT7_QNAME, (Object)tlvs.getAdjRibsInRoutesTlv().getCount().getValue()));
        }
        if (tlvs.getLocRibRoutesTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT8_QNAME, (Object)tlvs.getLocRibRoutesTlv().getCount().getValue()));
        }
        if (tlvs.getPerAfiSafiAdjRibInTlv() != null) {
            builder.withChild((DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(STAT9_QNAME)).withChild((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)AF_QNAME).withChild((NormalizedNode)((MapEntryNode)Builders.mapEntryBuilder().withChild((DataContainerChild)ImmutableNodes.leafNode((QName)COUNT_QNAME, (Object)tlvs.getPerAfiSafiAdjRibInTlv().getCount().getValue())).withNodeIdentifier((YangInstanceIdentifier.PathArgument)TablesUtil.toYangTablesKey(AF_QNAME, Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class)).build())).build()).build());
        }
        if (tlvs.getPerAfiSafiLocRibTlv() != null) {
            builder.withChild((DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(STAT10_QNAME)).withChild((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)AF_QNAME).withChild((NormalizedNode)((MapEntryNode)Builders.mapEntryBuilder().withChild((DataContainerChild)ImmutableNodes.leafNode((QName)COUNT_QNAME, (Object)tlvs.getPerAfiSafiLocRibTlv().getCount().getValue())).withNodeIdentifier((YangInstanceIdentifier.PathArgument)TablesUtil.toYangTablesKey(AF_QNAME, Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class)).build())).build()).build());
        }
        if (tlvs.getUpdatesTreatedAsWithdrawTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT11_QNAME, (Object)tlvs.getUpdatesTreatedAsWithdrawTlv().getCount().getValue()));
        }
        if (tlvs.getPrefixesTreatedAsWithdrawTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT11_QNAME, (Object)tlvs.getPrefixesTreatedAsWithdrawTlv().getCount().getValue()));
        }
        if (tlvs.getDuplicateUpdatesTlv() != null) {
            builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)STAT13_QNAME, (Object)tlvs.getDuplicateUpdatesTlv().getCount().getValue()));
        }
    }

    private static ContainerNode createMirrors(Mirror mirror, Timestamp timestamp) {
        DataContainerNodeBuilder builder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Mirrors.QNAME));
        builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_MIRROR_INFORMATION_QNAME, (Object)BmpRouterPeerImpl.toDom(MirrorInformationCode.forValue((int)mirror.getTlvs().getMirrorInformationTlv().getCode().getIntValue()))));
        builder.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)PEER_MIRROR_TIMESTAMP_QNAME, (Object)timestamp.getValue()));
        return (ContainerNode)builder.build();
    }

    private static String toDom(MirrorInformationCode informationCode) {
        switch (informationCode) {
            case ErroredPdu: {
                return "errored-pdu";
            }
            case MessageLost: {
                return "message-lost";
            }
        }
        return null;
    }

    private static String getStringIpAddress(IpAddressNoZone ipAddress) {
        if (ipAddress.getIpv4AddressNoZone() != null) {
            return ipAddress.getIpv4AddressNoZone().getValue();
        }
        return ipAddress.getIpv6AddressNoZone().getValue();
    }
}

