/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl.app;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.protocol.concepts.KeyMapping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.rfc2385.cfg.rev160324.Rfc2385Key;

public final class KeyConstructorUtil {
    private KeyConstructorUtil() {
    }

    public static KeyMapping constructKeys(Collection<MonitoredRouter> mrs) {
        KeyMapping ret = KeyMapping.getKeyMapping();
        if (mrs != null) {
            mrs.stream().filter(Objects::nonNull).filter(KeyConstructorUtil::isNotNullorEmpty).forEach(mr -> {
                Rfc2385Key rfc2385KeyPassword = mr.getPassword();
                ret.put((Object)IetfInetUtil.INSTANCE.inetAddressForNoZone((Object)mr.getAddress()), (Object)rfc2385KeyPassword.getValue().getBytes(StandardCharsets.US_ASCII));
            });
        }
        return ret;
    }

    private static boolean isNotNullorEmpty(MonitoredRouter mr) {
        Rfc2385Key password = mr.getPassword();
        return password != null && !password.getValue().isEmpty();
    }
}

