/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl.app;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.protocol.bgp.rib.spi.RIBExtensionConsumerContext;
import org.opendaylight.protocol.bmp.api.BmpSessionListener;
import org.opendaylight.protocol.bmp.api.BmpSessionListenerFactory;
import org.opendaylight.protocol.bmp.impl.app.BmpRouterImpl;
import org.opendaylight.protocol.bmp.impl.spi.BmpRouter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.RouterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RouterSessionManager
implements BmpSessionListenerFactory,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RouterSessionManager.class);
    private final Map<RouterId, BmpRouter> sessionListeners = new ConcurrentHashMap<RouterId, BmpRouter>();
    private final YangInstanceIdentifier yangRoutersId;
    private final DOMDataBroker domDataBroker;
    private final RIBExtensionConsumerContext extensions;
    private final BindingCodecTree tree;

    RouterSessionManager(YangInstanceIdentifier yangMonitorId, DOMDataBroker domDataBroker, RIBExtensionConsumerContext extensions, BindingCodecTree tree) {
        this.domDataBroker = domDataBroker;
        this.yangRoutersId = YangInstanceIdentifier.builder((YangInstanceIdentifier)yangMonitorId).node(Router.QNAME).build();
        this.extensions = extensions;
        this.tree = tree;
    }

    public BmpSessionListener getSessionListener() {
        return new BmpRouterImpl(this);
    }

    private synchronized boolean isSessionExist(BmpRouter sessionListener) {
        Objects.requireNonNull(sessionListener);
        return this.sessionListeners.containsKey(Objects.requireNonNull(sessionListener.getRouterId()));
    }

    synchronized boolean addSessionListener(BmpRouter sessionListener) {
        if (this.isSessionExist(sessionListener)) {
            LOG.warn("Session listener for router {} was already added.", (Object)sessionListener.getRouterId());
            return false;
        }
        this.sessionListeners.put(sessionListener.getRouterId(), sessionListener);
        return true;
    }

    synchronized void removeSessionListener(BmpRouter sessionListener) {
        if (!this.isSessionExist(sessionListener)) {
            LOG.warn("Session listener for router {} was already removed.", (Object)sessionListener.getRouterId());
            return;
        }
        this.sessionListeners.remove(sessionListener.getRouterId());
    }

    @Override
    public void close() throws Exception {
        for (BmpRouter sessionListener : this.sessionListeners.values()) {
            sessionListener.close();
        }
    }

    YangInstanceIdentifier getRoutersYangIId() {
        return this.yangRoutersId;
    }

    DOMDataBroker getDomDataBroker() {
        return this.domDataBroker;
    }

    RIBExtensionConsumerContext getExtensions() {
        return this.extensions;
    }

    BindingCodecTree getCodecTree() {
        return this.tree;
    }
}

