/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl.app;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCachingCodec;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.protocol.bgp.rib.spi.RIBSupport;
import org.opendaylight.protocol.bmp.impl.app.TablesUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.Attributes1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.Attributes2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpUnreachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.tables.Routes;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableChoiceNodeBuilder;

final class TableContext {
    private static final ContainerNode EMPTY_TABLE_ATTRIBUTES = ImmutableNodes.containerNode((QName)TablesUtil.BMP_ATTRIBUTES_QNAME);
    private static final InstanceIdentifier<MpReachNlri> MP_REACH_NLRI_II = InstanceIdentifier.create(Update.class).child(Attributes.class).augmentation(Attributes1.class).child(MpReachNlri.class);
    private static final InstanceIdentifier<MpUnreachNlri> MP_UNREACH_NLRI_II = InstanceIdentifier.create(Update.class).child(Attributes.class).augmentation(Attributes2.class).child(MpUnreachNlri.class);
    private static final YangInstanceIdentifier.NodeIdentifier BGP_ROUTES_NODE_ID = new YangInstanceIdentifier.NodeIdentifier(TablesUtil.BMP_ROUTES_QNAME);
    private final YangInstanceIdentifier tableId;
    private final RIBSupport tableSupport;
    private final BindingNormalizedNodeCachingCodec<Attributes> attributesCodec;
    private final BindingNormalizedNodeCachingCodec<MpReachNlri> reachNlriCodec;
    private final BindingNormalizedNodeCachingCodec<MpUnreachNlri> unreachNlriCodec;

    TableContext(RIBSupport tableSupport, YangInstanceIdentifier tableId, BindingCodecTree tree) {
        this.tableSupport = Objects.requireNonNull(tableSupport);
        this.tableId = Objects.requireNonNull(tableId);
        BindingCodecTreeNode tableCodecContext = tree.getSubtreeCodec(tableId);
        Preconditions.checkState((boolean)(tableCodecContext instanceof BindingDataObjectCodecTreeNode));
        BindingDataObjectCodecTreeNode routeListCodec = ((BindingDataObjectCodecTreeNode)tableCodecContext).streamChild(Routes.class).streamChild(this.tableSupport.routesCaseClass()).streamChild(this.tableSupport.routesContainerClass()).streamChild(this.tableSupport.routesListClass());
        this.attributesCodec = routeListCodec.streamChild(Attributes.class).createCachingCodec(this.tableSupport.cacheableAttributeObjects());
        this.reachNlriCodec = tree.getSubtreeCodec(MP_REACH_NLRI_II).createCachingCodec(this.tableSupport.cacheableNlriObjects());
        this.unreachNlriCodec = tree.getSubtreeCodec(MP_UNREACH_NLRI_II).createCachingCodec(this.tableSupport.cacheableNlriObjects());
    }

    YangInstanceIdentifier getTableId() {
        return this.tableId;
    }

    void createTable(DOMDataTreeWriteTransaction tx) {
        DataContainerNodeBuilder tb = ImmutableNodes.mapEntryBuilder();
        tb.withNodeIdentifier((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeIdentifierWithPredicates)this.tableId.getLastPathArgument()));
        tb.withChild((DataContainerChild)EMPTY_TABLE_ATTRIBUTES);
        YangInstanceIdentifier.NodeIdentifierWithPredicates tableKey = (YangInstanceIdentifier.NodeIdentifierWithPredicates)this.tableId.getLastPathArgument();
        for (Map.Entry e : tableKey.entrySet()) {
            tb.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)((QName)e.getKey()), e.getValue()));
        }
        tx.put(LogicalDatastoreType.OPERATIONAL, this.tableId, tb.withChild((DataContainerChild)ImmutableChoiceNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TablesUtil.BMP_ROUTES_QNAME)).build()).build());
    }

    void writeRoutes(DOMDataTreeWriteTransaction tx, MpReachNlri nlri, Attributes attributes) {
        ContainerNode domNlri = this.serializeReachNlri(nlri);
        ContainerNode routeAttributes = this.serializeAttributes(attributes);
        this.tableSupport.putRoutes(tx, this.tableId, domNlri, routeAttributes, BGP_ROUTES_NODE_ID);
    }

    void removeRoutes(DOMDataTreeWriteTransaction tx, MpUnreachNlri nlri) {
        this.tableSupport.deleteRoutes(tx, this.tableId, this.serializeUnreachNlri(nlri), BGP_ROUTES_NODE_ID);
    }

    private ContainerNode serializeUnreachNlri(MpUnreachNlri nlri) {
        Preconditions.checkState((this.unreachNlriCodec != null ? 1 : 0) != 0, (Object)"MpUnReachNlri codec not available");
        return (ContainerNode)this.unreachNlriCodec.serialize((BindingObject)nlri);
    }

    private ContainerNode serializeReachNlri(MpReachNlri nlri) {
        Preconditions.checkState((this.reachNlriCodec != null ? 1 : 0) != 0, (Object)"MpReachNlri codec not available");
        return (ContainerNode)this.reachNlriCodec.serialize((BindingObject)nlri);
    }

    private ContainerNode serializeAttributes(Attributes pathAttr) {
        Preconditions.checkState((this.attributesCodec != null ? 1 : 0) != 0, (Object)"Attributes codec not available");
        AttributesBuilder a = new AttributesBuilder(pathAttr);
        a.removeAugmentation(Attributes1.class);
        a.removeAugmentation(Attributes2.class);
        return (ContainerNode)this.attributesCodec.serialize((BindingObject)a.build());
    }
}

