/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl.app;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.BmpMonitor;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public final class TablesUtil {
    public static final QName BMP_TABLES_QNAME = QName.create((QName)BmpMonitor.QNAME, (String)"tables").intern();
    public static final QName BMP_ATTRIBUTES_QNAME = QName.create((QName)BmpMonitor.QNAME, (String)"attributes").intern();
    public static final QName BMP_ROUTES_QNAME = QName.create((QName)BmpMonitor.QNAME, (String)"routes").intern();
    public static final QName BMP_AFI_QNAME = QName.create((QName)BMP_TABLES_QNAME, (String)"afi").intern();
    public static final QName BMP_SAFI_QNAME = QName.create((QName)BMP_TABLES_QNAME, (String)"safi").intern();
    private static final String AFI = "afi";
    private static final String SAFI = "safi";

    private TablesUtil() {
    }

    public static YangInstanceIdentifier.NodeIdentifierWithPredicates toYangTablesKey(Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi) {
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)BMP_TABLES_QNAME, (Map)ImmutableMap.of((Object)BMP_AFI_QNAME, (Object)BindingReflections.findQName(afi), (Object)BMP_SAFI_QNAME, (Object)BindingReflections.findQName(safi)));
    }

    public static YangInstanceIdentifier.NodeIdentifierWithPredicates toYangTablesKey(QName nodeName, Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi) {
        QName afiQname = QName.create((QName)nodeName, (String)AFI).intern();
        QName safiQname = QName.create((QName)nodeName, (String)SAFI).intern();
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)nodeName, (Map)ImmutableMap.of((Object)afiQname, (Object)BindingReflections.findQName(afi), (Object)safiQname, (Object)BindingReflections.findQName(safi)));
    }

    public static YangInstanceIdentifier.NodeIdentifierWithPredicates toYangTablesKey(TablesKey tablesKey) {
        return TablesUtil.toYangTablesKey(tablesKey.getAfi(), tablesKey.getSafi());
    }
}

