/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl.config;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.protocol.bmp.api.BmpDispatcher;
import org.opendaylight.protocol.bmp.impl.app.BmpMonitoringStationImpl;
import org.opendaylight.protocol.bmp.impl.config.BmpDeployerDependencies;
import org.opendaylight.protocol.bmp.impl.spi.BmpMonitoringStation;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.OdlBmpMonitors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.BmpMonitorConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config.Server;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.BmpMonitor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.Monitor;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BmpDeployerImpl
implements ClusteredDataTreeChangeListener<OdlBmpMonitors>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BmpDeployerImpl.class);
    private static final long TIMEOUT_NS = TimeUnit.SECONDS.toNanos(5L);
    private static final InstanceIdentifier<OdlBmpMonitors> ODL_BMP_MONITORS_IID = InstanceIdentifier.create(OdlBmpMonitors.class);
    private static final YangInstanceIdentifier BMP_MONITOR_YII = YangInstanceIdentifier.of((QName)BmpMonitor.QNAME);
    private static final ContainerNode EMPTY_PARENT_NODE = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(BmpMonitor.QNAME)).addChild((NormalizedNode)((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)Monitor.QNAME).build())).build();
    private final BmpDispatcher dispatcher;
    private final @GuardedBy(value={"this"}) Map<MonitorId, BmpMonitoringStationImpl> bmpMonitorServices = new HashMap<MonitorId, BmpMonitoringStationImpl>();
    private final BmpDeployerDependencies bmpDeployerDependencies;
    private @GuardedBy(value={"this"}) ListenerRegistration<BmpDeployerImpl> registration;

    public BmpDeployerImpl(BmpDispatcher dispatcher, BmpDeployerDependencies bmpDeployerDependencies) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.bmpDeployerDependencies = Objects.requireNonNull(bmpDeployerDependencies);
    }

    public synchronized void init() {
        DOMDataTreeWriteTransaction wTx = this.bmpDeployerDependencies.getDomDataBroker().newWriteOnlyTransaction();
        wTx.merge(LogicalDatastoreType.OPERATIONAL, BMP_MONITOR_YII, (NormalizedNode)EMPTY_PARENT_NODE);
        wTx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("Successful commit");
            }

            public void onFailure(Throwable trw) {
                LOG.error("Failed commit", trw);
            }
        }, MoreExecutors.directExecutor());
        this.registration = this.bmpDeployerDependencies.getDataBroker().registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, ODL_BMP_MONITORS_IID), (DataTreeChangeListener)this);
    }

    public synchronized void onDataTreeChanged(Collection<DataTreeModification<OdlBmpMonitors>> changes) {
        DataTreeModification dataTreeModification = (DataTreeModification)Iterables.getOnlyElement(changes);
        Collection rootNode = dataTreeModification.getRootNode().getModifiedChildren();
        if (rootNode.isEmpty()) {
            return;
        }
        rootNode.forEach(dto -> this.handleModification((DataObjectModification<BmpMonitorConfig>)dto));
    }

    private synchronized void handleModification(DataObjectModification<BmpMonitorConfig> config) {
        DataObjectModification.ModificationType modificationType = config.getModificationType();
        LOG.trace("Bmp Monitor configuration has changed: {}, type modification {}", config, (Object)modificationType);
        switch (modificationType) {
            case DELETE: {
                this.removeBmpMonitor(((BmpMonitorConfig)config.getDataBefore()).getMonitorId());
                break;
            }
            case SUBTREE_MODIFIED: 
            case WRITE: {
                this.updateBmpMonitor((BmpMonitorConfig)config.getDataAfter());
                break;
            }
        }
    }

    private synchronized void updateBmpMonitor(BmpMonitorConfig bmpConfig) {
        MonitorId monitorId = bmpConfig.getMonitorId();
        BmpMonitoringStationImpl oldService = this.bmpMonitorServices.remove(monitorId);
        try {
            if (oldService != null) {
                oldService.closeServiceInstance().get(TIMEOUT_NS, TimeUnit.NANOSECONDS);
                oldService.close();
            }
            Server server = bmpConfig.getServer();
            InetSocketAddress inetAddress = Ipv4Util.toInetSocketAddress((IpAddressNoZone)server.getBindingAddress(), (PortNumber)server.getBindingPort());
            BmpMonitoringStationImpl monitor = new BmpMonitoringStationImpl(this.bmpDeployerDependencies, this.dispatcher, monitorId, inetAddress, bmpConfig.nonnullMonitoredRouter().values());
            this.bmpMonitorServices.put(monitorId, monitor);
        }
        catch (Exception e) {
            LOG.error("Failed to create Bmp Monitor {}.", (Object)monitorId, (Object)e);
        }
    }

    private synchronized void removeBmpMonitor(MonitorId monitorId) {
        BmpMonitoringStation service = this.bmpMonitorServices.remove(monitorId);
        if (service != null) {
            LOG.debug("Closing Bmp Monitor {}.", (Object)monitorId);
            try {
                service.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close Bmp Monitor {}.", (Object)monitorId, (Object)e);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.registration != null) {
            this.registration.close();
            this.registration = null;
        }
    }
}

