/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.impl.session;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.bmp.api.BmpSession;
import org.opendaylight.protocol.bmp.api.BmpSessionListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Reason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.TerminationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.termination.Tlvs;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BmpSessionImpl
extends SimpleChannelInboundHandler<Notification>
implements BmpSession {
    private static final Logger LOG = LoggerFactory.getLogger(BmpSessionImpl.class);
    private final BmpSessionListener listener;
    private @GuardedBy(value={"this"}) Channel channel;
    private @GuardedBy(value={"this"}) State state;

    public BmpSessionImpl(@NonNull BmpSessionListener listener) {
        this.listener = Objects.requireNonNull(listener);
        this.state = State.IDLE;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Notification msg) {
        this.handleMessage(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        LOG.debug("Channel {} inactive.", (Object)ctx.channel());
        this.endOfInput();
        try {
            super.channelInactive(ctx);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to delegate channel inactive event on channel " + ctx.channel(), e);
        }
    }

    public synchronized void channelActive(ChannelHandlerContext ctx) {
        this.channel = ctx.channel();
        LOG.info("Starting session {} <-> {}.", (Object)this.channel.localAddress(), (Object)this.channel.remoteAddress());
        Preconditions.checkArgument((State.IDLE == this.state ? 1 : 0) != 0);
        this.listener.onSessionUp((BmpSession)this);
        this.state = State.UP;
    }

    public synchronized void close() {
        LOG.info("Closing session: {}", (Object)this);
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
            this.state = State.IDLE;
        }
    }

    public synchronized InetAddress getRemoteAddress() {
        InetSocketAddress address = (InetSocketAddress)this.channel.remoteAddress();
        Objects.requireNonNull(address, "BMP Channel doesn't have a valid remote address.");
        return address.getAddress();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Exception caught in BMP Session.", cause);
        this.close();
        this.listener.onSessionDown((Exception)new IllegalStateException(cause));
    }

    public String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)((Object)this))).toString();
    }

    private synchronized MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("channel", (Object)this.channel);
        return toStringHelper;
    }

    private synchronized void handleMessage(Notification msg) {
        switch (this.state) {
            case UP: {
                if (msg instanceof InitiationMessage) {
                    this.state = State.INITIATED;
                    this.listener.onMessage(msg);
                    break;
                }
                LOG.warn("Unexpected message received {}, expected was BMP Initiation Message. Closing session.", (Object)msg);
                this.close();
                break;
            }
            case INITIATED: {
                if (msg instanceof TerminationMessage) {
                    LOG.info("Session {} terminated by remote with reason: {}", (Object)this, (Object)BmpSessionImpl.getTerminationReason((TerminationMessage)msg));
                    this.close();
                    break;
                }
                this.listener.onMessage(msg);
                break;
            }
            case IDLE: {
                throw new IllegalStateException("Received message " + msg + " while BMP Session " + this + " was not active.");
            }
        }
    }

    private static Reason getTerminationReason(TerminationMessage terminationMessage) {
        Tlvs tlvs = terminationMessage.getTlvs();
        if (tlvs != null && tlvs.getReasonTlv() != null) {
            return tlvs.getReasonTlv().getReason();
        }
        return null;
    }

    private void endOfInput() {
        this.listener.onSessionDown((Exception)new IOException("End of input detected. Closing the session."));
    }

    protected static enum State {
        IDLE,
        UP,
        INITIATED;

    }
}

