/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bmp.spi.parser.AbstractBmpPerPeerMessageParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.NotifyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.NotifyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerDownNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.PeerDownNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.down.Data;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.down.data.FsmEventCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.down.data.FsmEventCodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.down.data.Notification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.down.data.notification.NotificationBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PeerDownHandler
extends AbstractBmpPerPeerMessageParser<PeerDownNotificationBuilder> {
    private static final int MESSAGE_TYPE = 2;
    private final MessageRegistry msgRegistry = this.getBgpMessageRegistry();

    public PeerDownHandler(MessageRegistry bgpMssageRegistry) {
        super(bgpMssageRegistry);
    }

    public void serializeMessageBody(org.opendaylight.yangtools.yang.binding.Notification message, ByteBuf buffer) {
        super.serializeMessageBody(message, buffer);
        Preconditions.checkArgument((boolean)(message instanceof PeerDownNotification), (Object)"An instance of PeerDownNotification is required");
        PeerDownNotification peerDown = (PeerDownNotification)message;
        if (peerDown.isLocalSystemClosed().booleanValue()) {
            if (peerDown.getData() instanceof FsmEventCode) {
                ByteBufWriteUtil.writeUnsignedByte((Short)Reason.REASON_TWO.getValue(), (ByteBuf)buffer);
                ByteBufWriteUtil.writeUnsignedShort((Integer)((FsmEventCode)peerDown.getData()).getFsmEventCode(), (ByteBuf)buffer);
            } else if (peerDown.getData() instanceof Notification) {
                ByteBufWriteUtil.writeUnsignedByte((Short)Reason.REASON_ONE.getValue(), (ByteBuf)buffer);
                this.serializePDU(peerDown.getData(), buffer);
            }
        } else if (peerDown.getData() instanceof Notification) {
            ByteBufWriteUtil.writeUnsignedByte((Short)Reason.REASON_THREE.getValue(), (ByteBuf)buffer);
            this.serializePDU(peerDown.getData(), buffer);
        } else {
            ByteBufWriteUtil.writeUnsignedByte((Short)Reason.REASON_FOUR.getValue(), (ByteBuf)buffer);
        }
    }

    private void serializePDU(Data data, ByteBuf buffer) {
        Notification notification = (Notification)data;
        this.msgRegistry.serializeMessage((org.opendaylight.yangtools.yang.binding.Notification)new NotifyBuilder((NotifyMessage)notification.getNotification()).build(), buffer);
    }

    public org.opendaylight.yangtools.yang.binding.Notification parseMessageBody(ByteBuf bytes) throws BmpDeserializationException {
        PeerDownNotificationBuilder peerDown = new PeerDownNotificationBuilder().setPeerHeader(PeerDownHandler.parsePerPeerHeader((ByteBuf)bytes));
        Reason reason = Reason.forValue(bytes.readUnsignedByte());
        if (reason != null) {
            switch (reason) {
                case REASON_ONE: {
                    peerDown.setLocalSystemClosed(Boolean.valueOf(true));
                    peerDown.setData((Data)this.parseBgpNotificationMessage(bytes));
                    break;
                }
                case REASON_TWO: {
                    peerDown.setLocalSystemClosed(Boolean.valueOf(true));
                    peerDown.setData((Data)new FsmEventCodeBuilder().setFsmEventCode(Integer.valueOf(bytes.readUnsignedShort())).build());
                    break;
                }
                case REASON_THREE: 
                case REASON_FOUR: {
                    peerDown.setLocalSystemClosed(Boolean.valueOf(false));
                    peerDown.setData((Data)this.parseBgpNotificationMessage(bytes));
                    break;
                }
                case REASON_FIVE: {
                    peerDown.setLocalSystemClosed(Boolean.valueOf(false));
                    break;
                }
            }
        }
        return peerDown.build();
    }

    private Notification parseBgpNotificationMessage(ByteBuf bytes) throws BmpDeserializationException {
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.down.data.NotificationBuilder notificationCBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.peer.down.data.NotificationBuilder();
        NotificationBuilder notificationBuilder = new NotificationBuilder();
        try {
            org.opendaylight.yangtools.yang.binding.Notification not = this.msgRegistry.parseMessage(bytes, null);
            Objects.requireNonNull(not, "Notify message may not be null.");
            Preconditions.checkArgument((boolean)(not instanceof NotifyMessage), (Object)"An instance of NotifyMessage is required");
            notificationBuilder.fieldsFrom((DataObject)((NotifyMessage)not));
            notificationCBuilder.setNotification(notificationBuilder.build());
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            throw new BmpDeserializationException("Error while parsing BGP Notification message.", e);
        }
        return notificationCBuilder.build();
    }

    public int getBmpMessageType() {
        return 2;
    }

    public static enum Reason {
        REASON_ONE(1),
        REASON_TWO(2),
        REASON_THREE(3),
        REASON_FOUR(4),
        REASON_FIVE(5);

        private static final Map<Short, Reason> VALUE_MAP;
        private final short value;

        private Reason(short value) {
            this.value = value;
        }

        public static Reason forValue(short value) {
            return VALUE_MAP.get(value);
        }

        public short getValue() {
            return this.value;
        }

        static {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (Reason enumItem : Reason.values()) {
                b.put((Object)enumItem.getValue(), (Object)enumItem);
            }
            VALUE_MAP = b.build();
        }
    }
}

