/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bmp.spi.parser.AbstractBmpPerPeerMessageParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvRegistry;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.StatsReportsMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.StatsReportsMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.AdjRibsInRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.DuplicatePrefixAdvertisementsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.DuplicateUpdatesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.DuplicateWithdrawsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.InvalidatedAsConfedLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.InvalidatedAsPathLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.InvalidatedClusterListLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.InvalidatedOriginatorIdTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.LocRibRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.PerAfiSafiAdjRibInTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.PerAfiSafiLocRibTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.PrefixesTreatedAsWithdrawTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.RejectedPrefixesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.stat.tlvs.UpdatesTreatedAsWithdrawTlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Notification;

public class StatisticsReportHandler
extends AbstractBmpPerPeerMessageParser<TlvsBuilder> {
    private static final int MESSAGE_TYPE = 1;

    public StatisticsReportHandler(MessageRegistry bgpMssageRegistry, BmpTlvRegistry tlvRegistry) {
        super(bgpMssageRegistry, tlvRegistry);
    }

    public void serializeMessageBody(Notification message, ByteBuf buffer) {
        super.serializeMessageBody(message, buffer);
        Preconditions.checkArgument((boolean)(message instanceof StatsReportsMessage), (Object)"An instance of Statistics Reports message is required");
        StatsReportsMessage statsReport = (StatsReportsMessage)message;
        this.serializeTlvs(statsReport.getTlvs(), buffer);
    }

    public Notification parseMessageBody(ByteBuf bytes) throws BmpDeserializationException {
        StatsReportsMessageBuilder statReport = new StatsReportsMessageBuilder().setPeerHeader(StatisticsReportHandler.parsePerPeerHeader((ByteBuf)bytes));
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        bytes.skipBytes(4);
        this.parseTlvs((Builder)tlvsBuilder, bytes);
        return statReport.setTlvs(tlvsBuilder.build()).build();
    }

    public int getBmpMessageType() {
        return 1;
    }

    private void serializeTlvs(Tlvs tlvs, ByteBuf output) {
        AtomicInteger counter = new AtomicInteger(0);
        ByteBuf tlvsBuffer = Unpooled.buffer();
        this.serializeStatTlv((Tlv)tlvs.getRejectedPrefixesTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getDuplicatePrefixAdvertisementsTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getDuplicateWithdrawsTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getInvalidatedClusterListLoopTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getInvalidatedAsPathLoopTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getInvalidatedOriginatorIdTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getInvalidatedAsConfedLoopTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getAdjRibsInRoutesTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getLocRibRoutesTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getPerAfiSafiAdjRibInTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getPerAfiSafiLocRibTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getUpdatesTreatedAsWithdrawTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getPrefixesTreatedAsWithdrawTlv(), tlvsBuffer, counter);
        this.serializeStatTlv((Tlv)tlvs.getDuplicateUpdatesTlv(), tlvsBuffer, counter);
        ByteBufWriteUtil.writeUnsignedInt((Long)counter.longValue(), (ByteBuf)output);
        output.writeBytes(tlvsBuffer);
    }

    private void serializeStatTlv(Tlv tlv, ByteBuf tlvsBuffer, AtomicInteger counter) {
        if (tlv != null) {
            counter.incrementAndGet();
            this.serializeTlv(tlv, tlvsBuffer);
        }
    }

    protected void addTlv(TlvsBuilder builder, Tlv tlv) {
        if (tlv instanceof AdjRibsInRoutesTlv) {
            builder.setAdjRibsInRoutesTlv((AdjRibsInRoutesTlv)tlv);
        } else if (tlv instanceof DuplicatePrefixAdvertisementsTlv) {
            builder.setDuplicatePrefixAdvertisementsTlv((DuplicatePrefixAdvertisementsTlv)tlv);
        } else if (tlv instanceof DuplicateWithdrawsTlv) {
            builder.setDuplicateWithdrawsTlv((DuplicateWithdrawsTlv)tlv);
        } else if (tlv instanceof InvalidatedAsConfedLoopTlv) {
            builder.setInvalidatedAsConfedLoopTlv((InvalidatedAsConfedLoopTlv)tlv);
        } else if (tlv instanceof InvalidatedAsPathLoopTlv) {
            builder.setInvalidatedAsPathLoopTlv((InvalidatedAsPathLoopTlv)tlv);
        } else if (tlv instanceof InvalidatedClusterListLoopTlv) {
            builder.setInvalidatedClusterListLoopTlv((InvalidatedClusterListLoopTlv)tlv);
        } else if (tlv instanceof InvalidatedOriginatorIdTlv) {
            builder.setInvalidatedOriginatorIdTlv((InvalidatedOriginatorIdTlv)tlv);
        } else if (tlv instanceof LocRibRoutesTlv) {
            builder.setLocRibRoutesTlv((LocRibRoutesTlv)tlv);
        } else if (tlv instanceof RejectedPrefixesTlv) {
            builder.setRejectedPrefixesTlv((RejectedPrefixesTlv)tlv);
        } else if (tlv instanceof PerAfiSafiAdjRibInTlv) {
            builder.setPerAfiSafiAdjRibInTlv((PerAfiSafiAdjRibInTlv)tlv);
        } else if (tlv instanceof PerAfiSafiLocRibTlv) {
            builder.setPerAfiSafiLocRibTlv((PerAfiSafiLocRibTlv)tlv);
        } else if (tlv instanceof UpdatesTreatedAsWithdrawTlv) {
            builder.setUpdatesTreatedAsWithdrawTlv((UpdatesTreatedAsWithdrawTlv)tlv);
        } else if (tlv instanceof PrefixesTreatedAsWithdrawTlv) {
            builder.setPrefixesTreatedAsWithdrawTlv((PrefixesTreatedAsWithdrawTlv)tlv);
        } else if (tlv instanceof DuplicateUpdatesTlv) {
            builder.setDuplicateUpdatesTlv((DuplicateUpdatesTlv)tlv);
        }
    }
}

