/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvSerializer;
import org.opendaylight.protocol.bmp.spi.parser.TlvUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.description.tlv.DescriptionTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.description.tlv.DescriptionTlvBuilder;

public class DescriptionTlvHandler
implements BmpTlvParser,
BmpTlvSerializer {
    public static final int TYPE = 1;

    public void serializeTlv(Tlv tlv, ByteBuf output) {
        Preconditions.checkArgument((boolean)(tlv instanceof DescriptionTlv), (Object)"DescriptionTlv is mandatory.");
        TlvUtil.formatTlvAscii((int)1, (String)((DescriptionTlv)tlv).getDescription(), (ByteBuf)output);
    }

    public Tlv parseTlv(ByteBuf buffer) throws BmpDeserializationException {
        if (buffer == null) {
            return null;
        }
        return new DescriptionTlvBuilder().setDescription(buffer.toString(StandardCharsets.US_ASCII)).build();
    }
}

