/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bmp.parser.message.AbstractBmpMessageTest;
import org.opendaylight.protocol.bmp.parser.message.TestUtil;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev180329.TerminationMessage;
import org.opendaylight.yangtools.yang.binding.Notification;

public class TerminationHandlerTest
extends AbstractBmpMessageTest {
    private static final byte[] TERMINATION_MESSAGE = new byte[]{3, 0, 0, 0, 32, 5, 0, 1, 0, 2, 0, 0, 0, 0, 0, 6, 101, 114, 114, 111, 114, 49, 0, 0, 0, 6, 101, 114, 114, 111, 114, 49};

    @Test
    public void testSerializeTerminationMessage() throws BmpDeserializationException {
        ByteBuf buffer = Unpooled.buffer();
        this.getBmpMessageRegistry().serializeMessage((Notification)TestUtil.createTerminationMsg(), buffer);
        Assert.assertArrayEquals((byte[])TERMINATION_MESSAGE, (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testParseTerminationMessage() throws BmpDeserializationException {
        TerminationMessage parsedInitMsg = (TerminationMessage)this.getBmpMessageRegistry().parseMessage(Unpooled.copiedBuffer((byte[])TERMINATION_MESSAGE));
        Assert.assertEquals((Object)TestUtil.createTerminationMsg(), (Object)parsedInitMsg);
    }
}

