/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bmp.parser.message.AbstractBmpMessageTest;
import org.opendaylight.protocol.bmp.parser.message.TestUtil;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessage;
import org.opendaylight.yangtools.yang.binding.Notification;

public class RouteMonitoringMessageHandlerTest
extends AbstractBmpMessageTest {
    private static final byte[] ROUTE_MONIT_MSG = new byte[]{3, 0, 0, 0, -76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 10, 10, 0, 0, 0, 72, 10, 10, 10, 10, 0, 0, 0, 5, 0, 0, 0, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -124, 2, 0, 12, 24, 10, 10, 20, 24, 20, 20, 10, 24, 30, 10, 10, 0, 85, 64, 1, 1, 0, -128, 26, 11, 1, 0, 11, 0, 0, 0, 0, 0, 0, 0, 1, 64, 2, 0, 64, 3, 4, 100, 100, 100, 100, -128, 4, 4, 0, 0, 0, 123, 64, 5, 4, 0, 0, 0, 2, 64, 6, 0, -64, 7, 8, 0, 0, 0, 72, 20, 20, 20, 20, -64, 8, 8, -1, -1, -1, 101, -1, -1, -1, 102, -128, 9, 4, 12, 12, 12, 12, -128, 10, 8, 30, 30, 30, 30, 40, 40, 40, 40, 24, 10, 10, 10, 24, 20, 20, 20, 24, 30, 30, 30};

    @Test
    public void testSerializeRouteMonitMessage() throws BmpDeserializationException {
        ByteBuf buffer = Unpooled.buffer();
        this.getBmpMessageRegistry().serializeMessage((Notification)TestUtil.createRouteMonitMsg(false), buffer);
        Assert.assertArrayEquals((byte[])ROUTE_MONIT_MSG, (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testParseRouteMonitMessage() throws BmpDeserializationException {
        RouteMonitoringMessage parsedInitMsg = (RouteMonitoringMessage)this.getBmpMessageRegistry().parseMessage(Unpooled.copiedBuffer((byte[])ROUTE_MONIT_MSG));
        Assert.assertEquals((Object)TestUtil.createRouteMonitMsg(true), (Object)parsedInitMsg);
    }
}

