/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.OptionalCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.OptionalCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AggregatorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AigpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AtomicAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.CommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPrefBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDiscBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.aigp.AigpTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.SegmentsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.NlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.WithdrawnRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.WithdrawnRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ClusterIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.AdjRibInType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.MirrorInformationCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDownNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDownNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Reason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMirroringMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMirroringMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatsReportsMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatsReportsMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.TerminationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.TerminationMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.description.tlv.DescriptionTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.information.tlv.MirrorInformationTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.name.tlv.NameTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.Data;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.FsmEventCodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.NotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeaderBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.InformationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.ReceivedOpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.reason.tlv.ReasonTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.route.monitoring.message.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.route.monitoring.message.UpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.AdjRibsInRoutesTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicatePrefixAdvertisementsTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateUpdatesTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateWithdrawsTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsConfedLoopTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsPathLoopTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedClusterListLoopTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedOriginatorIdTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.LocRibRoutesTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiLocRibTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PrefixesTreatedAsWithdrawTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.RejectedPrefixesTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.UpdatesTreatedAsWithdrawTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.informations.StringInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.informations.StringInformationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.AccumulatedIgpMetric;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

public final class TestUtil {
    public static final Ipv4AddressNoZone IPV4_ADDRESS_10 = new Ipv4AddressNoZone("10.10.10.10");
    private static final Ipv4AddressNoZone IPV4_ADDRESS_20 = new Ipv4AddressNoZone("20.20.20.20");
    private static final Ipv4AddressNoZone IPV4_ADDRESS_30 = new Ipv4AddressNoZone("30.30.30.30");
    private static final Ipv4AddressNoZone IPV4_ADDRESS_40 = new Ipv4AddressNoZone("40.40.40.40");
    private static final Ipv4AddressNoZone IPV4_ADDRESS_12 = new Ipv4AddressNoZone("12.12.12.12");
    private static final Ipv4AddressNoZone IPV4_ADDRESS_100 = new Ipv4AddressNoZone("100.100.100.100");
    public static final AsNumber PEER_AS = new AsNumber(Uint32.valueOf((long)72L));
    public static final PortNumber PEER_LOCAL_PORT = new PortNumber(Uint16.valueOf((int)220));
    public static final PortNumber PEER_REMOTE_PORT = new PortNumber(Uint16.valueOf((int)5000));

    private TestUtil() {
    }

    public static InitiationMessage createInitMsg(String sysDescr, String sysName, String info) {
        InitiationMessageBuilder initMsgBuilder = new InitiationMessageBuilder();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.initiation.TlvsBuilder tlvsBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.initiation.TlvsBuilder();
        tlvsBuilder.setDescriptionTlv(new DescriptionTlvBuilder().setDescription(sysDescr).build());
        tlvsBuilder.setNameTlv(new NameTlvBuilder().setName(sysName).build());
        tlvsBuilder.setStringInformation((List)Lists.newArrayList((Object[])new StringInformation[]{TestUtil.createStringInfo(info)}));
        return initMsgBuilder.setTlvs(tlvsBuilder.build()).build();
    }

    private static StringInformation createStringInfo(String string) {
        return new StringInformationBuilder().setStringTlv(new StringTlvBuilder().setStringInfo(string).build()).build();
    }

    public static TerminationMessage createTerminationMsg() {
        TerminationMessageBuilder terminatMsgBuilder = new TerminationMessageBuilder();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.termination.TlvsBuilder tlvsBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.termination.TlvsBuilder();
        tlvsBuilder.setReasonTlv(new ReasonTlvBuilder().setReason(Reason.AdministrativelyClosed).build());
        tlvsBuilder.setStringInformation((List)Lists.newArrayList((Object[])new StringInformation[]{TestUtil.createStringInfo("error1"), TestUtil.createStringInfo("error1")}));
        return terminatMsgBuilder.setTlvs(tlvsBuilder.build()).build();
    }

    private static PeerHeader createPeerHeader(Ipv4AddressNoZone bgpId, AdjRibInType ribType) {
        PeerHeaderBuilder peerHeaderBuilder = new PeerHeaderBuilder().setAddress(new IpAddressNoZone(IPV4_ADDRESS_10)).setAs(PEER_AS).setBgpId(bgpId).setAdjRibInType(ribType).setTimestampMicro(new Timestamp(Uint32.TEN)).setTimestampSec(new Timestamp(Uint32.valueOf((int)5))).setIpv4(Boolean.valueOf(true)).setType(PeerType.forValue((int)0));
        return peerHeaderBuilder.build();
    }

    private static PeerHeader createPeerHeader(Ipv4AddressNoZone bgpId) {
        return TestUtil.createPeerHeader(bgpId, AdjRibInType.PrePolicy);
    }

    private static PeerHeader createPeerHeader() {
        return TestUtil.createPeerHeader(IPV4_ADDRESS_10);
    }

    public static PeerUpNotification createPeerUpNotification(Ipv4AddressNoZone bgpId, boolean multiprotocol) {
        return new PeerUpNotificationBuilder().setLocalAddress(new IpAddressNoZone(IPV4_ADDRESS_10)).setLocalPort(PEER_LOCAL_PORT).setPeerHeader(TestUtil.createPeerHeader(bgpId)).setReceivedOpen(new ReceivedOpenBuilder(TestUtil.createOpen(multiprotocol)).build()).setRemotePort(PEER_REMOTE_PORT).setSentOpen((SentOpen)TestUtil.createOpen(multiprotocol)).setInformation(new InformationBuilder().setStringInformation((List)ImmutableList.of((Object)new StringInformationBuilder().setStringTlv(new StringTlvBuilder().setStringInfo("aaaa").build()).build())).build()).build();
    }

    static PeerUpNotification createPeerUpNotification() {
        return TestUtil.createPeerUpNotification(IPV4_ADDRESS_10, false);
    }

    public static PeerDownNotification createPeerDownFSM() {
        PeerDownNotificationBuilder peerDownNotifBuilder = new PeerDownNotificationBuilder().setData((Data)new FsmEventCodeBuilder().setFsmEventCode(Uint16.valueOf((int)24)).build()).setLocalSystemClosed(Boolean.valueOf(true)).setPeerHeader(TestUtil.createPeerHeader());
        return peerDownNotifBuilder.build();
    }

    public static PeerDownNotification createPeerDownNotification(Ipv4AddressNoZone bgpId) {
        NotificationBuilder notifBuilder = new NotificationBuilder().setNotification(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.NotificationBuilder().setErrorCode(Uint8.ONE).setErrorSubcode(Uint8.ONE).build());
        return new PeerDownNotificationBuilder().setData((Data)notifBuilder.build()).setLocalSystemClosed(Boolean.valueOf(true)).setPeerHeader(TestUtil.createPeerHeader(bgpId)).build();
    }

    static PeerDownNotification createPeerDownNotification() {
        return TestUtil.createPeerDownNotification(IPV4_ADDRESS_10);
    }

    private static List<BgpParameters> createBgpParameters(boolean multiprotocol) {
        BgpParametersBuilder bgpParamBuilder = new BgpParametersBuilder().setOptionalCapabilities(TestUtil.createOptionalCapabilities(multiprotocol));
        ArrayList<BgpParameters> bgpParameters = new ArrayList<BgpParameters>();
        bgpParameters.add(bgpParamBuilder.build());
        return bgpParameters;
    }

    private static List<OptionalCapabilities> createOptionalCapabilities(boolean multiprotocol) {
        OptionalCapabilitiesBuilder optCapabilitiesBuilder = new OptionalCapabilitiesBuilder().setCParameters(new CParametersBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)70))).build()).build());
        CParametersBuilder paramsBuilder = new CParametersBuilder();
        if (multiprotocol) {
            paramsBuilder.addAugmentation((Augmentation)new CParameters1Builder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build()).build());
        }
        OptionalCapabilitiesBuilder optCapabilitiesBuilder2 = new OptionalCapabilitiesBuilder().setCParameters(paramsBuilder.setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)80))).build()).build());
        ArrayList<OptionalCapabilities> optCapabilities = new ArrayList<OptionalCapabilities>();
        optCapabilities.add(optCapabilitiesBuilder.build());
        optCapabilities.add(optCapabilitiesBuilder2.build());
        return optCapabilities;
    }

    private static OpenMessage createOpen(boolean mutiprotocol) {
        SentOpenBuilder sentOpenBuilder = new SentOpenBuilder().setBgpIdentifier(IPV4_ADDRESS_20).setHoldTimer(Uint16.valueOf((int)1000)).setMyAsNumber(Uint16.valueOf((int)72)).setBgpParameters(TestUtil.createBgpParameters(mutiprotocol));
        return sentOpenBuilder.build();
    }

    public static RouteMonitoringMessage createRouteMonitMsg(boolean withNormalizedIpv4Prefixes) {
        return TestUtil.createRouteMonitMsg(withNormalizedIpv4Prefixes, IPV4_ADDRESS_10, AdjRibInType.PrePolicy);
    }

    public static RouteMonitoringMessage createRouteMonitMsg(boolean withNormalizedIpv4Prefixes, Ipv4AddressNoZone bgpId, AdjRibInType ribType) {
        return new RouteMonitoringMessageBuilder().setPeerHeader(TestUtil.createPeerHeader(bgpId, ribType)).setUpdate(TestUtil.createUpdate(withNormalizedIpv4Prefixes)).build();
    }

    public static RouteMirroringMessage createRouteMirrorMsg(Ipv4AddressNoZone bgpId) {
        RouteMirroringMessageBuilder routeMirrorMsgBuilder = new RouteMirroringMessageBuilder().setPeerHeader(TestUtil.createPeerHeader(bgpId));
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.TlvsBuilder tlvsBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.TlvsBuilder();
        tlvsBuilder.setMirrorInformationTlv(new MirrorInformationTlvBuilder().setCode(MirrorInformationCode.forValue((int)1)).build());
        routeMirrorMsgBuilder.setTlvs(tlvsBuilder.build());
        return routeMirrorMsgBuilder.build();
    }

    private static Update createUpdate(boolean withNormalizedIpv4Prefixes) {
        UpdateBuilder updateBuilder = new UpdateBuilder().setAttributes(TestUtil.createAttributes()).setWithdrawnRoutes(TestUtil.createWithdrawnRoutes());
        if (withNormalizedIpv4Prefixes) {
            updateBuilder.setNlri(TestUtil.createNlriWitNormalizedIpv4Prefixes());
        } else {
            updateBuilder.setNlri(TestUtil.createNlri());
        }
        return updateBuilder.build();
    }

    private static Attributes createAttributes() {
        ArrayList asSequences = Lists.newArrayList((Object[])new AsNumber[]{new AsNumber(Uint32.valueOf((int)72)), new AsNumber(Uint32.valueOf((int)82)), new AsNumber(Uint32.valueOf((int)92))});
        ArrayList segments = new ArrayList();
        SegmentsBuilder segmentsBuild = new SegmentsBuilder();
        segmentsBuild.setAsSequence((List)asSequences).build();
        return new AttributesBuilder().setAggregator(new AggregatorBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)72))).setNetworkAddress(IPV4_ADDRESS_20).build()).setAigp(new AigpBuilder().setAigpTlv(new AigpTlvBuilder().setMetric(new AccumulatedIgpMetric(Uint64.ONE)).build()).build()).setAsPath(new AsPathBuilder().setSegments(segments).build()).setAtomicAggregate(new AtomicAggregateBuilder().build()).setClusterId(new ClusterIdBuilder().setCluster((List)Lists.newArrayList((Object[])new ClusterIdentifier[]{new ClusterIdentifier(IPV4_ADDRESS_30), new ClusterIdentifier(IPV4_ADDRESS_40)})).build()).setCNextHop((CNextHop)new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(IPV4_ADDRESS_100).build()).build()).setCommunities(TestUtil.createCommunities()).setLocalPref(new LocalPrefBuilder().setPref(Uint32.valueOf((int)2)).build()).setMultiExitDisc(new MultiExitDiscBuilder().setMed(Uint32.valueOf((int)123)).build()).setOrigin(new OriginBuilder().setValue(BgpOrigin.Igp).build()).setOriginatorId(new OriginatorIdBuilder().setOriginator(IPV4_ADDRESS_12).build()).build();
    }

    private static List<Communities> createCommunities() {
        ArrayList<Communities> communities = new ArrayList<Communities>();
        CommunitiesBuilder commBuilder = new CommunitiesBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)65535))).setSemantics(Uint16.valueOf((int)65381));
        CommunitiesBuilder commBuilder2 = new CommunitiesBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)65535))).setSemantics(Uint16.valueOf((int)65382));
        communities.add(commBuilder.build());
        communities.add(commBuilder2.build());
        return communities;
    }

    private static List<Nlri> createNlri() {
        Nlri n1 = new NlriBuilder().setPrefix(new Ipv4Prefix("10.10.10.10/24")).build();
        Nlri n2 = new NlriBuilder().setPrefix(new Ipv4Prefix("20.20.20.20/24")).build();
        Nlri n3 = new NlriBuilder().setPrefix(new Ipv4Prefix("30.30.30.30/24")).build();
        return Lists.newArrayList((Object[])new Nlri[]{n1, n2, n3});
    }

    private static List<Nlri> createNlriWitNormalizedIpv4Prefixes() {
        Nlri n1 = new NlriBuilder().setPrefix(new Ipv4Prefix("10.10.10.0/24")).build();
        Nlri n2 = new NlriBuilder().setPrefix(new Ipv4Prefix("20.20.20.0/24")).build();
        Nlri n3 = new NlriBuilder().setPrefix(new Ipv4Prefix("30.30.30.0/24")).build();
        return Lists.newArrayList((Object[])new Nlri[]{n1, n2, n3});
    }

    private static List<WithdrawnRoutes> createWithdrawnRoutes() {
        WithdrawnRoutes w1 = new WithdrawnRoutesBuilder().setPrefix(new Ipv4Prefix("10.10.20.0/24")).build();
        WithdrawnRoutes w2 = new WithdrawnRoutesBuilder().setPrefix(new Ipv4Prefix("20.20.10.0/24")).build();
        WithdrawnRoutes w3 = new WithdrawnRoutesBuilder().setPrefix(new Ipv4Prefix("30.10.10.0/24")).build();
        return Lists.newArrayList((Object[])new WithdrawnRoutes[]{w1, w2, w3});
    }

    public static StatsReportsMessage createStatsReportMsg(Ipv4AddressNoZone bgpId) {
        StatsReportsMessageBuilder statsReportMsgBuilder = new StatsReportsMessageBuilder();
        statsReportMsgBuilder.setPeerHeader(TestUtil.createPeerHeader(bgpId));
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        tlvsBuilder.setAdjRibsInRoutesTlv(new AdjRibsInRoutesTlvBuilder().setCount(new Gauge64(Uint64.TEN)).build());
        tlvsBuilder.setDuplicatePrefixAdvertisementsTlv(new DuplicatePrefixAdvertisementsTlvBuilder().setCount(new Counter32(Uint32.valueOf((long)16L))).build());
        tlvsBuilder.setDuplicateWithdrawsTlv(new DuplicateWithdrawsTlvBuilder().setCount(new Counter32(Uint32.valueOf((long)11L))).build());
        tlvsBuilder.setInvalidatedAsConfedLoopTlv(new InvalidatedAsConfedLoopTlvBuilder().setCount(new Counter32(Uint32.valueOf((long)55L))).build());
        tlvsBuilder.setInvalidatedAsPathLoopTlv(new InvalidatedAsPathLoopTlvBuilder().setCount(new Counter32(Uint32.valueOf((long)66L))).build());
        tlvsBuilder.setInvalidatedClusterListLoopTlv(new InvalidatedClusterListLoopTlvBuilder().setCount(new Counter32(Uint32.valueOf((long)53L))).build());
        tlvsBuilder.setInvalidatedOriginatorIdTlv(new InvalidatedOriginatorIdTlvBuilder().setCount(new Counter32(Uint32.valueOf((long)70L))).build());
        tlvsBuilder.setLocRibRoutesTlv(new LocRibRoutesTlvBuilder().setCount(new Gauge64(Uint64.valueOf((long)100L))).build());
        tlvsBuilder.setRejectedPrefixesTlv(new RejectedPrefixesTlvBuilder().setCount(new Counter32(Uint32.valueOf((long)8L))).build());
        tlvsBuilder.setPerAfiSafiAdjRibInTlv(new PerAfiSafiAdjRibInTlvBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setCount(new Gauge64(Uint64.valueOf((long)9L))).build());
        tlvsBuilder.setPerAfiSafiLocRibTlv(new PerAfiSafiLocRibTlvBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setCount(new Gauge64(Uint64.TEN)).build());
        tlvsBuilder.setUpdatesTreatedAsWithdrawTlv(new UpdatesTreatedAsWithdrawTlvBuilder().setCount(new Counter32(Uint32.valueOf((long)11L))).build());
        tlvsBuilder.setPrefixesTreatedAsWithdrawTlv(new PrefixesTreatedAsWithdrawTlvBuilder().setCount(new Counter32(Uint32.valueOf((long)12L))).build());
        tlvsBuilder.setDuplicateUpdatesTlv(new DuplicateUpdatesTlvBuilder().setCount(new Counter32(Uint32.valueOf((long)13L))).build());
        return statsReportMsgBuilder.setTlvs(tlvsBuilder.build()).build();
    }

    static StatsReportsMessage createStatsReportMsg() {
        return TestUtil.createStatsReportMsg(IPV4_ADDRESS_10);
    }

    public static RouteMonitoringMessage createRouteMonMsgWithEndOfRibMarker(Ipv4AddressNoZone bgpId, AdjRibInType ribType) {
        return new RouteMonitoringMessageBuilder().setPeerHeader(TestUtil.createPeerHeader(bgpId, ribType)).setUpdate(TestUtil.createEndOfRibMarker()).build();
    }

    private static Update createEndOfRibMarker() {
        return new UpdateBuilder().build();
    }
}

