/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bmp.parser.message.AbstractBmpMessageTest;
import org.opendaylight.protocol.bmp.parser.message.TestUtil;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationMessage;
import org.opendaylight.yangtools.yang.binding.Notification;

public class InitiationHandlerTest
extends AbstractBmpMessageTest {
    private static final String STR_INFO = "The information field type 0";
    private static final String SYS_DESCR = "SysDescr type 1";
    private static final String SYS_NAME = "SysName type 2";
    private static final byte[] INIT_MSG = new byte[]{3, 0, 0, 0, 75, 4, 0, 2, 0, 14, 83, 121, 115, 78, 97, 109, 101, 32, 116, 121, 112, 101, 32, 50, 0, 1, 0, 15, 83, 121, 115, 68, 101, 115, 99, 114, 32, 116, 121, 112, 101, 32, 49, 0, 0, 0, 28, 84, 104, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 102, 105, 101, 108, 100, 32, 116, 121, 112, 101, 32, 48};

    @Test
    public void testSerializeInitiationMessage() throws BmpDeserializationException {
        ByteBuf buffer = Unpooled.buffer();
        this.getBmpMessageRegistry().serializeMessage((Notification)TestUtil.createInitMsg(SYS_DESCR, SYS_NAME, STR_INFO), buffer);
        Assert.assertArrayEquals((byte[])INIT_MSG, (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testParseInitiationMessage() throws BmpDeserializationException {
        InitiationMessage parsedInitMsg = (InitiationMessage)this.getBmpMessageRegistry().parseMessage(Unpooled.copiedBuffer((byte[])INIT_MSG));
        Assert.assertEquals((Object)TestUtil.createInitMsg(SYS_DESCR, SYS_NAME, STR_INFO), (Object)parsedInitMsg);
    }
}

