/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bmp.parser.message.AbstractBmpMessageTest;
import org.opendaylight.protocol.bmp.parser.message.TestUtil;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDownNotification;
import org.opendaylight.yangtools.yang.binding.Notification;

public class PeerDownHandlerTest
extends AbstractBmpMessageTest {
    private static final byte[] PEER_DOWN_FSM_DATA = new byte[]{3, 0, 0, 0, 51, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 10, 10, 0, 0, 0, 72, 10, 10, 10, 10, 0, 0, 0, 5, 0, 0, 0, 10, 2, 0, 24};
    private static final byte[] PEER_DOWN_NOTIFICATION = new byte[]{3, 0, 0, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 10, 10, 0, 0, 0, 72, 10, 10, 10, 10, 0, 0, 0, 5, 0, 0, 0, 10, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 21, 3, 1, 1};

    @Test
    public void testSerializePeerDownNotificationFSM() throws BmpDeserializationException {
        ByteBuf buffer = Unpooled.buffer();
        this.getBmpMessageRegistry().serializeMessage((Notification)TestUtil.createPeerDownFSM(), buffer);
        Assert.assertArrayEquals((byte[])PEER_DOWN_FSM_DATA, (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testSerializePeerDownNotification() throws BmpDeserializationException {
        ByteBuf buffer = Unpooled.buffer();
        this.getBmpMessageRegistry().serializeMessage((Notification)TestUtil.createPeerDownNotification(), buffer);
        Assert.assertArrayEquals((byte[])PEER_DOWN_NOTIFICATION, (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testParsePeerDownNotificationFSM() throws BmpDeserializationException {
        PeerDownNotification parsedPeerDownFSM = (PeerDownNotification)this.getBmpMessageRegistry().parseMessage(Unpooled.copiedBuffer((byte[])PEER_DOWN_FSM_DATA));
        Assert.assertEquals((Object)TestUtil.createPeerDownFSM(), (Object)parsedPeerDownFSM);
    }

    @Test
    public void testParsePeerDownNotification() throws BmpDeserializationException {
        PeerDownNotification parsedPeerDownNotif = (PeerDownNotification)this.getBmpMessageRegistry().parseMessage(Unpooled.copiedBuffer((byte[])PEER_DOWN_NOTIFICATION));
        Assert.assertEquals((Object)TestUtil.createPeerDownNotification(), (Object)parsedPeerDownNotif);
    }
}

