/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bmp.parser.message.AbstractBmpMessageTest;
import org.opendaylight.protocol.bmp.parser.message.TestUtil;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatsReportsMessage;
import org.opendaylight.yangtools.yang.binding.Notification;

public class StatisticsReportHandlerTest
extends AbstractBmpMessageTest {
    private static final byte[] STATS_REPORT = new byte[]{3, 0, 0, 0, -70, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 10, 10, 0, 0, 0, 72, 10, 10, 10, 10, 0, 0, 0, 5, 0, 0, 0, 10, 0, 0, 0, 14, 0, 0, 0, 4, 0, 0, 0, 8, 0, 1, 0, 4, 0, 0, 0, 16, 0, 2, 0, 4, 0, 0, 0, 11, 0, 3, 0, 4, 0, 0, 0, 53, 0, 4, 0, 4, 0, 0, 0, 66, 0, 5, 0, 4, 0, 0, 0, 70, 0, 6, 0, 4, 0, 0, 0, 55, 0, 7, 0, 8, 0, 0, 0, 0, 0, 0, 0, 10, 0, 8, 0, 8, 0, 0, 0, 0, 0, 0, 0, 100, 0, 9, 0, 11, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 9, 0, 10, 0, 11, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 10, 0, 11, 0, 4, 0, 0, 0, 11, 0, 12, 0, 4, 0, 0, 0, 12, 0, 13, 0, 4, 0, 0, 0, 13};

    @Test
    public void testSerializeStatsReportMessage() throws BmpDeserializationException {
        ByteBuf buffer = Unpooled.buffer((int)STATS_REPORT.length);
        this.getBmpMessageRegistry().serializeMessage((Notification)TestUtil.createStatsReportMsg(), buffer);
        Assert.assertArrayEquals((byte[])STATS_REPORT, (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testParseStatsReportMessage() throws BmpDeserializationException {
        StatsReportsMessage parsedStatsReportsMsg = (StatsReportsMessage)this.getBmpMessageRegistry().parseMessage(Unpooled.copiedBuffer((byte[])STATS_REPORT));
        Assert.assertEquals((Object)TestUtil.createStatsReportMsg(), (Object)parsedStatsReportsMsg);
    }
}

