/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.protocol.bmp.spi.parser.AbstractBmpMessageWithTlvParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.TerminationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.TerminationMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.reason.tlv.ReasonTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.informations.StringInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.informations.StringInformationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.termination.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.termination.TlvsBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;

public class TerminationHandler
extends AbstractBmpMessageWithTlvParser<TlvsBuilder> {
    private static final int MESSAGE_TYPE = 5;

    public TerminationHandler(BmpTlvRegistry tlvRegistry) {
        super(tlvRegistry);
    }

    public TerminationMessage parseMessageBody(ByteBuf bytes) throws BmpDeserializationException {
        TerminationMessageBuilder terminationMessage = new TerminationMessageBuilder();
        TlvsBuilder tlvsBuilder = new TlvsBuilder().setStringInformation((List)ImmutableList.of());
        this.parseTlvs(tlvsBuilder, bytes);
        if (tlvsBuilder.getReasonTlv() == null || tlvsBuilder.getReasonTlv().getReason() == null) {
            throw new BmpDeserializationException("Inclusion of Reason TLV is mandatory.");
        }
        return terminationMessage.setTlvs(tlvsBuilder.build()).build();
    }

    public void serializeMessageBody(Notification<?> message, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(message instanceof TerminationMessage), (Object)"An instance of Termination message is required");
        TerminationMessage terminationMsg = (TerminationMessage)message;
        this.serializeTlvs(terminationMsg.getTlvs(), buffer);
    }

    public int getBmpMessageType() {
        return 5;
    }

    protected void serializeTlvs(Tlvs tlvs, ByteBuf output) {
        this.serializeTlv((Tlv)tlvs.getReasonTlv(), output);
        if (tlvs.getStringInformation() != null) {
            for (StringInformation stringInfo : tlvs.getStringInformation()) {
                if (stringInfo.getStringTlv() == null) continue;
                this.serializeTlv((Tlv)stringInfo.getStringTlv(), output);
            }
        }
    }

    protected void addTlv(TlvsBuilder builder, Tlv tlv) {
        if (tlv instanceof ReasonTlv) {
            builder.setReasonTlv((ReasonTlv)tlv);
        } else if (tlv instanceof StringTlv) {
            builder.setStringInformation((List)ImmutableList.builder().addAll((Iterable)builder.getStringInformation()).add((Object)new StringInformationBuilder().setStringTlv(new StringTlvBuilder((StringTlv)tlv).build()).build()).build());
        }
    }
}

