/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvSerializer;
import org.opendaylight.protocol.bmp.spi.parser.TlvUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiLocRibTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiLocRibTlvBuilder;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class StatType010TlvHandler
implements BmpTlvParser,
BmpTlvSerializer {
    public static final int TYPE = 10;
    private final AddressFamilyRegistry afiRegistry;
    private final SubsequentAddressFamilyRegistry safiRegistry;

    public StatType010TlvHandler(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        this.afiRegistry = Objects.requireNonNull(afiReg, "AddressFamily cannot be null");
        this.safiRegistry = Objects.requireNonNull(safiReg, "SubsequentAddressFamily cannot be null");
    }

    public void serializeTlv(Tlv tlv, ByteBuf output) {
        Preconditions.checkArgument((boolean)(tlv instanceof PerAfiSafiLocRibTlv), (Object)"PerAfiSafiLocRibInTlv is mandatory.");
        PerAfiSafiLocRibTlv perAfiSafi = (PerAfiSafiLocRibTlv)tlv;
        ByteBuf buffer = Unpooled.buffer();
        Integer afiInt = this.afiRegistry.numberForClass(perAfiSafi.getAfi());
        buffer.writeShort(afiInt != null ? afiInt : 0);
        buffer.writeByte(this.safiRegistry.numberForClass(perAfiSafi.getSafi()).intValue());
        ByteBufUtils.write((ByteBuf)buffer, (Uint64)perAfiSafi.getCount().getValue());
        TlvUtil.formatTlv((int)10, (ByteBuf)buffer, (ByteBuf)output);
    }

    public Tlv parseTlv(ByteBuf buffer) throws BmpDeserializationException {
        if (buffer == null) {
            return null;
        }
        return new PerAfiSafiLocRibTlvBuilder().setAfi(this.afiRegistry.classForFamily(buffer.readUnsignedShort())).setSafi(this.safiRegistry.classForFamily((int)buffer.readUnsignedByte())).setCount(new Gauge64(ByteBufUtils.readUint64((ByteBuf)buffer))).build();
    }
}

