/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.bmp.parser.message.InitiationHandler;
import org.opendaylight.protocol.bmp.parser.message.PeerDownHandler;
import org.opendaylight.protocol.bmp.parser.message.PeerUpHandler;
import org.opendaylight.protocol.bmp.parser.message.RouteMirroringMessageHandler;
import org.opendaylight.protocol.bmp.parser.message.RouteMonitoringMessageHandler;
import org.opendaylight.protocol.bmp.parser.message.StatisticsReportHandler;
import org.opendaylight.protocol.bmp.parser.message.TerminationHandler;
import org.opendaylight.protocol.bmp.parser.tlv.DescriptionTlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.MirrorInformationTlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.NameTlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.ReasonTlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType000TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType001TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType002TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType003TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType004TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType005TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType006TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType007TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType008TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType009TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType010TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType011TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType012TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType013TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StringTlvHandler;
import org.opendaylight.protocol.bmp.spi.parser.BmpMessageParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpMessageSerializer;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvSerializer;
import org.opendaylight.protocol.bmp.spi.registry.BmpExtensionProviderActivator;
import org.opendaylight.protocol.bmp.spi.registry.BmpExtensionProviderContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDownNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMirroringMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatsReportsMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.TerminationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.description.tlv.DescriptionTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.information.tlv.MirrorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.name.tlv.NameTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.reason.tlv.ReasonTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.AdjRibsInRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicatePrefixAdvertisementsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateUpdatesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateWithdrawsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsConfedLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsPathLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedClusterListLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedOriginatorIdTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.LocRibRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiLocRibTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PrefixesTreatedAsWithdrawTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.RejectedPrefixesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.UpdatesTreatedAsWithdrawTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlv;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Singleton
@Component(immediate=true, property={"type=org.opendaylight.protocol.bmp.parser.BmpActivator"})
public final class BmpActivator
implements BmpExtensionProviderActivator {
    private final MessageRegistry messageRegistry;
    private final AddressFamilyRegistry afiRegistry;
    private final SubsequentAddressFamilyRegistry safiRegistry;

    @Inject
    @Activate
    public BmpActivator(@Reference BGPExtensionConsumerContext context) {
        this.messageRegistry = context.getMessageRegistry();
        this.afiRegistry = context.getAddressFamilyRegistry();
        this.safiRegistry = context.getSubsequentAddressFamilyRegistry();
    }

    public List<Registration> start(BmpExtensionProviderContext context) {
        DescriptionTlvHandler descriptionTlvHandler = new DescriptionTlvHandler();
        NameTlvHandler nameTlvHandler = new NameTlvHandler();
        StringTlvHandler stringTlvHandler = new StringTlvHandler();
        ReasonTlvHandler reasonTlvHandler = new ReasonTlvHandler();
        MirrorInformationTlvHandler informationTlvHandler = new MirrorInformationTlvHandler();
        StatType000TlvHandler statType000TlvHandler = new StatType000TlvHandler();
        StatType001TlvHandler statType001TlvHandler = new StatType001TlvHandler();
        StatType002TlvHandler statType002TlvHandler = new StatType002TlvHandler();
        StatType003TlvHandler statType003TlvHandler = new StatType003TlvHandler();
        StatType004TlvHandler statType004TlvHandler = new StatType004TlvHandler();
        StatType005TlvHandler statType005TlvHandler = new StatType005TlvHandler();
        StatType006TlvHandler statType006TlvHandler = new StatType006TlvHandler();
        StatType007TlvHandler statType007TlvHandler = new StatType007TlvHandler();
        StatType008TlvHandler statType008TlvHandler = new StatType008TlvHandler();
        StatType009TlvHandler statType009TlvHandler = new StatType009TlvHandler(this.afiRegistry, this.safiRegistry);
        StatType010TlvHandler statType010TlvHandler = new StatType010TlvHandler(this.afiRegistry, this.safiRegistry);
        StatType011TlvHandler statType011TlvHandler = new StatType011TlvHandler();
        StatType012TlvHandler statType012TlvHandler = new StatType012TlvHandler();
        StatType013TlvHandler statType013TlvHandler = new StatType013TlvHandler();
        InitiationHandler initiationHandler = new InitiationHandler(context.getBmpInitiationTlvRegistry());
        TerminationHandler terminationHandler = new TerminationHandler(context.getBmpTerminationTlvRegistry());
        PeerUpHandler peerUpHandler = new PeerUpHandler(this.messageRegistry, context.getBmpPeerUpTlvRegistry());
        PeerDownHandler peerDownHandler = new PeerDownHandler(this.messageRegistry);
        RouteMirroringMessageHandler routeMirroringMessageHandler = new RouteMirroringMessageHandler(this.messageRegistry, context.getBmpRouteMirroringTlvRegistry());
        StatisticsReportHandler statisticsReportHandler = new StatisticsReportHandler(this.messageRegistry, context.getBmpStatisticsTlvRegistry());
        RouteMonitoringMessageHandler routeMonitoringMessageHandler = new RouteMonitoringMessageHandler(this.messageRegistry);
        return List.of(context.registerBmpInitiationTlvParser(1, (BmpTlvParser)descriptionTlvHandler), context.registerBmpInitiationTlvSerializer(DescriptionTlv.class, (BmpTlvSerializer)descriptionTlvHandler), context.registerBmpInitiationTlvParser(2, (BmpTlvParser)nameTlvHandler), context.registerBmpInitiationTlvSerializer(NameTlv.class, (BmpTlvSerializer)nameTlvHandler), context.registerBmpInitiationTlvParser(0, (BmpTlvParser)stringTlvHandler), context.registerBmpInitiationTlvSerializer(StringTlv.class, (BmpTlvSerializer)stringTlvHandler), context.registerBmpTerminationTlvParser(0, (BmpTlvParser)stringTlvHandler), context.registerBmpTerminationTlvSerializer(StringTlv.class, (BmpTlvSerializer)stringTlvHandler), context.registerBmpPeerUpTlvParser(0, (BmpTlvParser)stringTlvHandler), context.registerBmpPeerUpTlvSerializer(StringTlv.class, (BmpTlvSerializer)stringTlvHandler), context.registerBmpTerminationTlvParser(1, (BmpTlvParser)reasonTlvHandler), context.registerBmpTerminationTlvSerializer(ReasonTlv.class, (BmpTlvSerializer)reasonTlvHandler), context.registerBmpRouteMirroringTlvParser(1, (BmpTlvParser)informationTlvHandler), context.registerBmpRouteMirroringTlvSerializer(MirrorInformationTlv.class, (BmpTlvSerializer)informationTlvHandler), context.registerBmpStatisticsTlvParser(0, (BmpTlvParser)statType000TlvHandler), context.registerBmpStatisticsTlvSerializer(RejectedPrefixesTlv.class, (BmpTlvSerializer)statType000TlvHandler), context.registerBmpStatisticsTlvParser(1, (BmpTlvParser)statType001TlvHandler), context.registerBmpStatisticsTlvSerializer(DuplicatePrefixAdvertisementsTlv.class, (BmpTlvSerializer)statType001TlvHandler), context.registerBmpStatisticsTlvParser(2, (BmpTlvParser)statType002TlvHandler), context.registerBmpStatisticsTlvSerializer(DuplicateWithdrawsTlv.class, (BmpTlvSerializer)statType002TlvHandler), context.registerBmpStatisticsTlvParser(3, (BmpTlvParser)statType003TlvHandler), context.registerBmpStatisticsTlvSerializer(InvalidatedClusterListLoopTlv.class, (BmpTlvSerializer)statType003TlvHandler), context.registerBmpStatisticsTlvParser(4, (BmpTlvParser)statType004TlvHandler), context.registerBmpStatisticsTlvSerializer(InvalidatedAsPathLoopTlv.class, (BmpTlvSerializer)statType004TlvHandler), context.registerBmpStatisticsTlvParser(5, (BmpTlvParser)statType005TlvHandler), context.registerBmpStatisticsTlvSerializer(InvalidatedOriginatorIdTlv.class, (BmpTlvSerializer)statType005TlvHandler), context.registerBmpStatisticsTlvParser(6, (BmpTlvParser)statType006TlvHandler), context.registerBmpStatisticsTlvSerializer(InvalidatedAsConfedLoopTlv.class, (BmpTlvSerializer)statType006TlvHandler), context.registerBmpStatisticsTlvParser(7, (BmpTlvParser)statType007TlvHandler), context.registerBmpStatisticsTlvSerializer(AdjRibsInRoutesTlv.class, (BmpTlvSerializer)statType007TlvHandler), context.registerBmpStatisticsTlvParser(8, (BmpTlvParser)statType008TlvHandler), context.registerBmpStatisticsTlvSerializer(LocRibRoutesTlv.class, (BmpTlvSerializer)statType008TlvHandler), context.registerBmpStatisticsTlvParser(9, (BmpTlvParser)statType009TlvHandler), context.registerBmpStatisticsTlvSerializer(PerAfiSafiAdjRibInTlv.class, (BmpTlvSerializer)statType009TlvHandler), context.registerBmpStatisticsTlvParser(10, (BmpTlvParser)statType010TlvHandler), context.registerBmpStatisticsTlvSerializer(PerAfiSafiLocRibTlv.class, (BmpTlvSerializer)statType010TlvHandler), context.registerBmpStatisticsTlvParser(11, (BmpTlvParser)statType011TlvHandler), context.registerBmpStatisticsTlvSerializer(UpdatesTreatedAsWithdrawTlv.class, (BmpTlvSerializer)statType011TlvHandler), context.registerBmpStatisticsTlvParser(12, (BmpTlvParser)statType012TlvHandler), context.registerBmpStatisticsTlvSerializer(PrefixesTreatedAsWithdrawTlv.class, (BmpTlvSerializer)statType012TlvHandler), context.registerBmpStatisticsTlvParser(13, (BmpTlvParser)statType013TlvHandler), context.registerBmpStatisticsTlvSerializer(DuplicateUpdatesTlv.class, (BmpTlvSerializer)statType013TlvHandler), context.registerBmpMessageParser(initiationHandler.getBmpMessageType(), (BmpMessageParser)initiationHandler), context.registerBmpMessageSerializer(InitiationMessage.class, (BmpMessageSerializer)initiationHandler), context.registerBmpMessageParser(terminationHandler.getBmpMessageType(), (BmpMessageParser)terminationHandler), context.registerBmpMessageSerializer(TerminationMessage.class, (BmpMessageSerializer)terminationHandler), context.registerBmpMessageParser(peerUpHandler.getBmpMessageType(), (BmpMessageParser)peerUpHandler), context.registerBmpMessageSerializer(PeerUpNotification.class, (BmpMessageSerializer)peerUpHandler), context.registerBmpMessageParser(peerDownHandler.getBmpMessageType(), (BmpMessageParser)peerDownHandler), context.registerBmpMessageSerializer(PeerDownNotification.class, (BmpMessageSerializer)peerDownHandler), context.registerBmpMessageParser(statisticsReportHandler.getBmpMessageType(), (BmpMessageParser)statisticsReportHandler), context.registerBmpMessageSerializer(StatsReportsMessage.class, (BmpMessageSerializer)statisticsReportHandler), context.registerBmpMessageParser(routeMonitoringMessageHandler.getBmpMessageType(), (BmpMessageParser)routeMonitoringMessageHandler), context.registerBmpMessageSerializer(RouteMonitoringMessage.class, (BmpMessageSerializer)routeMonitoringMessageHandler), context.registerBmpMessageParser(routeMirroringMessageHandler.getBmpMessageType(), (BmpMessageParser)routeMirroringMessageHandler), context.registerBmpMessageSerializer(RouteMirroringMessage.class, (BmpMessageSerializer)routeMirroringMessageHandler));
    }
}

