/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bmp.spi.parser.AbstractBmpPerPeerMessageParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDownNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDownNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.Data;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.FsmEventCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.FsmEventCodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.Notification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.NotificationBuilder;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class PeerDownHandler
extends AbstractBmpPerPeerMessageParser<PeerDownNotificationBuilder> {
    private static final int MESSAGE_TYPE = 2;
    private final MessageRegistry msgRegistry = this.getBgpMessageRegistry();

    public PeerDownHandler(MessageRegistry bgpMssageRegistry) {
        super(bgpMssageRegistry);
    }

    public void serializeMessageBody(org.opendaylight.yangtools.binding.Notification<?> message, ByteBuf buffer) {
        super.serializeMessageBody(message, buffer);
        Preconditions.checkArgument((boolean)(message instanceof PeerDownNotification), (Object)"An instance of PeerDownNotification is required");
        PeerDownNotification peerDown = (PeerDownNotification)message;
        if (peerDown.getLocalSystemClosed().booleanValue()) {
            if (peerDown.getData() instanceof FsmEventCode) {
                buffer.writeByte((int)Reason.REASON_TWO.getValue());
                ByteBufUtils.writeOrZero((ByteBuf)buffer, (Uint16)((FsmEventCode)peerDown.getData()).getFsmEventCode());
            } else if (peerDown.getData() instanceof Notification) {
                buffer.writeByte((int)Reason.REASON_ONE.getValue());
                this.serializePDU(peerDown.getData(), buffer);
            }
        } else if (peerDown.getData() instanceof Notification) {
            buffer.writeByte((int)Reason.REASON_THREE.getValue());
            this.serializePDU(peerDown.getData(), buffer);
        } else {
            buffer.writeByte((int)Reason.REASON_FOUR.getValue());
        }
    }

    private void serializePDU(Data data, ByteBuf buffer) {
        Notification notification = (Notification)data;
        this.msgRegistry.serializeMessage((org.opendaylight.yangtools.binding.Notification)new NotifyBuilder((NotifyMessage)notification.getNotification()).build(), buffer);
    }

    public PeerDownNotification parseMessageBody(ByteBuf bytes) throws BmpDeserializationException {
        PeerDownNotificationBuilder peerDown = new PeerDownNotificationBuilder().setPeerHeader(PeerDownHandler.parsePerPeerHeader((ByteBuf)bytes));
        Reason reason = Reason.forValue(bytes.readUnsignedByte());
        if (reason != null) {
            switch (reason.ordinal()) {
                case 0: {
                    peerDown.setLocalSystemClosed(Boolean.TRUE);
                    peerDown.setData((Data)this.parseBgpNotificationMessage(bytes));
                    break;
                }
                case 1: {
                    peerDown.setLocalSystemClosed(Boolean.TRUE);
                    peerDown.setData((Data)new FsmEventCodeBuilder().setFsmEventCode(ByteBufUtils.readUint16((ByteBuf)bytes)).build());
                    break;
                }
                case 2: 
                case 3: {
                    peerDown.setLocalSystemClosed(Boolean.FALSE);
                    peerDown.setData((Data)this.parseBgpNotificationMessage(bytes));
                    break;
                }
                case 4: {
                    peerDown.setLocalSystemClosed(Boolean.FALSE);
                    break;
                }
            }
        }
        return peerDown.build();
    }

    private Notification parseBgpNotificationMessage(ByteBuf bytes) throws BmpDeserializationException {
        NotificationBuilder notificationCBuilder = new NotificationBuilder();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.NotificationBuilder notificationBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.NotificationBuilder();
        try {
            org.opendaylight.yangtools.binding.Notification not = this.msgRegistry.parseMessage(bytes, null);
            Objects.requireNonNull(not, "Notify message may not be null.");
            Preconditions.checkArgument((boolean)(not instanceof NotifyMessage), (Object)"An instance of NotifyMessage is required");
            notificationBuilder.fieldsFrom((Grouping)((NotifyMessage)not));
            notificationCBuilder.setNotification(notificationBuilder.build());
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            throw new BmpDeserializationException("Error while parsing BGP Notification message.", e);
        }
        return notificationCBuilder.build();
    }

    public int getBmpMessageType() {
        return 2;
    }

    public static enum Reason {
        REASON_ONE(1),
        REASON_TWO(2),
        REASON_THREE(3),
        REASON_FOUR(4),
        REASON_FIVE(5);

        private static final Map<Short, Reason> VALUE_MAP;
        private final short value;

        private Reason(short value) {
            this.value = value;
        }

        public static Reason forValue(short value) {
            return VALUE_MAP.get(value);
        }

        public short getValue() {
            return this.value;
        }

        static {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (Reason enumItem : Reason.values()) {
                b.put((Object)enumItem.getValue(), (Object)enumItem);
            }
            VALUE_MAP = b.build();
        }
    }
}

