/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bmp.spi.parser.AbstractBmpPerPeerMessageParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvRegistry;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.Information;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.InformationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.ReceivedOpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.informations.StringInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.informations.StringInformationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlvBuilder;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class PeerUpHandler
extends AbstractBmpPerPeerMessageParser<InformationBuilder> {
    private static final int MESSAGE_TYPE = 3;
    private final MessageRegistry msgRegistry = this.getBgpMessageRegistry();

    public PeerUpHandler(MessageRegistry bgpMssageRegistry, BmpTlvRegistry tlvRegistry) {
        super(bgpMssageRegistry, tlvRegistry);
    }

    public void serializeMessageBody(Notification<?> message, ByteBuf buffer) {
        super.serializeMessageBody(message, buffer);
        Preconditions.checkArgument((boolean)(message instanceof PeerUpNotification), (Object)"An instance of Peer Up notification is required");
        PeerUpNotification peerUp = (PeerUpNotification)message;
        if (peerUp.getLocalAddress().getIpv4AddressNoZone() != null) {
            buffer.writeZero(12);
            Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)peerUp.getLocalAddress().getIpv4AddressNoZone(), (ByteBuf)buffer);
        } else {
            Ipv6Util.writeIpv6Address((Ipv6AddressNoZone)peerUp.getLocalAddress().getIpv6AddressNoZone(), (ByteBuf)buffer);
        }
        ByteBufUtils.write((ByteBuf)buffer, (Uint16)peerUp.getLocalPort().getValue());
        ByteBufUtils.write((ByteBuf)buffer, (Uint16)peerUp.getRemotePort().getValue());
        this.msgRegistry.serializeMessage((Notification)new OpenBuilder((OpenMessage)peerUp.getSentOpen()).build(), buffer);
        this.msgRegistry.serializeMessage((Notification)new OpenBuilder((OpenMessage)peerUp.getReceivedOpen()).build(), buffer);
        this.serializeTlvs(peerUp.getInformation(), buffer);
    }

    private void serializeTlvs(Information tlvs, ByteBuf output) {
        if (tlvs != null) {
            for (StringInformation stringInfo : tlvs.nonnullStringInformation()) {
                if (stringInfo.getStringTlv() == null) continue;
                this.serializeTlv((Tlv)stringInfo.getStringTlv(), output);
            }
        }
    }

    public PeerUpNotification parseMessageBody(ByteBuf bytes) throws BmpDeserializationException {
        PeerUpNotificationBuilder peerUpNot = new PeerUpNotificationBuilder().setPeerHeader(PeerUpHandler.parsePerPeerHeader((ByteBuf)bytes));
        if (peerUpNot.getPeerHeader().getIpv4().booleanValue()) {
            bytes.skipBytes(12);
            peerUpNot.setLocalAddress(new IpAddressNoZone(Ipv4Util.addressForByteBuf((ByteBuf)bytes)));
        } else {
            peerUpNot.setLocalAddress(new IpAddressNoZone(Ipv6Util.addressForByteBuf((ByteBuf)bytes)));
        }
        peerUpNot.setLocalPort(new PortNumber(ByteBufUtils.readUint16((ByteBuf)bytes)));
        peerUpNot.setRemotePort(new PortNumber(ByteBufUtils.readUint16((ByteBuf)bytes)));
        try {
            Notification opSent = this.msgRegistry.parseMessage(bytes.readSlice(PeerUpHandler.getBgpMessageLength(bytes)), null);
            Objects.requireNonNull(opSent, "Error on parse Sent OPEN Message, Sent OPEN Message is null");
            Preconditions.checkArgument((boolean)(opSent instanceof OpenMessage), (Object)"An instance of OpenMessage notification is required");
            OpenMessage sent = (OpenMessage)opSent;
            Notification opRec = this.msgRegistry.parseMessage(bytes.readSlice(PeerUpHandler.getBgpMessageLength(bytes)), null);
            Objects.requireNonNull(opRec, "Error on parse Received  OPEN Message, Received  OPEN Message is null");
            Preconditions.checkArgument((boolean)(opRec instanceof OpenMessage), (Object)"An instance of OpenMessage notification is required");
            OpenMessage received = (OpenMessage)opRec;
            peerUpNot.setSentOpen(new SentOpenBuilder(sent).build());
            peerUpNot.setReceivedOpen(new ReceivedOpenBuilder(received).build());
            InformationBuilder infos = new InformationBuilder();
            if (bytes.isReadable()) {
                this.parseTlvs(infos, bytes);
                peerUpNot.setInformation(infos.build());
            }
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            throw new BmpDeserializationException("Error while parsing BGP Open Message.", e);
        }
        return peerUpNot.build();
    }

    protected void addTlv(InformationBuilder builder, Tlv tlv) {
        if (tlv instanceof StringTlv) {
            ImmutableList.Builder stringInfoListBuilder = ImmutableList.builder();
            if (builder.getStringInformation() != null) {
                stringInfoListBuilder.addAll((Iterable)builder.getStringInformation());
            }
            builder.setStringInformation((List)stringInfoListBuilder.add((Object)new StringInformationBuilder().setStringTlv(new StringTlvBuilder((StringTlv)tlv).build()).build()).build());
        }
    }

    public int getBmpMessageType() {
        return 3;
    }

    private static int getBgpMessageLength(ByteBuf buffer) {
        return buffer.getUnsignedShort(buffer.readerIndex() + 16);
    }
}

