/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.protocol.bmp.spi.parser.AbstractBmpMessageWithTlvParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.InitiationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.InitiationMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.description.tlv.DescriptionTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.initiation.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.initiation.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.name.tlv.NameTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.string.informations.StringInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.string.informations.StringInformationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.string.tlv.StringTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.string.tlv.StringTlvBuilder;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Notification;

public class InitiationHandler
extends AbstractBmpMessageWithTlvParser<TlvsBuilder> {
    private static final int MESSAGE_TYPE = 4;

    public InitiationHandler(BmpTlvRegistry tlvRegistry) {
        super(tlvRegistry);
    }

    public void serializeMessageBody(Notification message, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(message instanceof InitiationMessage), (Object)"Incorrect instance of BGP message. The Initiation Message is expected.");
        InitiationMessage initiation = (InitiationMessage)message;
        this.serializeTlvs(initiation.getTlvs(), buffer);
    }

    public Notification parseMessageBody(ByteBuf bytes) throws BmpDeserializationException {
        InitiationMessageBuilder initiationBuilder = new InitiationMessageBuilder();
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        tlvsBuilder.setStringInformation((List)ImmutableList.of());
        this.parseTlvs((Builder)tlvsBuilder, bytes);
        if (tlvsBuilder.getDescriptionTlv() == null || tlvsBuilder.getDescriptionTlv().getDescription() == null) {
            throw new BmpDeserializationException("Inclusion of sysDescr TLV is mandatory.");
        }
        if (tlvsBuilder.getNameTlv() == null || tlvsBuilder.getNameTlv().getName() == null) {
            throw new BmpDeserializationException("Inclusion of sysName TLV is mandatory.");
        }
        return initiationBuilder.setTlvs(tlvsBuilder.build()).build();
    }

    public int getBmpMessageType() {
        return 4;
    }

    private void serializeTlvs(Tlvs tlvs, ByteBuf output) {
        this.serializeTlv((Tlv)tlvs.getNameTlv(), output);
        this.serializeTlv((Tlv)tlvs.getDescriptionTlv(), output);
        if (tlvs.getStringInformation() != null) {
            for (StringInformation stringInfo : tlvs.getStringInformation()) {
                if (stringInfo.getStringTlv() == null) continue;
                this.serializeTlv((Tlv)stringInfo.getStringTlv(), output);
            }
        }
    }

    protected void addTlv(TlvsBuilder builder, Tlv tlv) {
        if (tlv instanceof DescriptionTlv) {
            builder.setDescriptionTlv((DescriptionTlv)tlv);
        } else if (tlv instanceof NameTlv) {
            builder.setNameTlv((NameTlv)tlv);
        } else if (tlv instanceof StringTlv) {
            builder.setStringInformation((List)ImmutableList.builder().addAll((Iterable)builder.getStringInformation()).add((Object)new StringInformationBuilder().setStringTlv(new StringTlvBuilder((StringTlv)tlv).build()).build()).build());
        }
    }
}

